ORCA/M Asm65816 2.1.0

0001 5C94                       title 'PopUpDefProc' 
0002 5C94              **********************************************************************
0003 5C94              *
0004 5C94              * PopUp Control Def Proc
0005 5C94              *
0006 5C94              *
0007 5C94              * Copyright Apple Computer, Inc. 1988-92
0008 5C94              * All Rights Reserved
0009 5C94              *
0010 5C94              * 17-Sep-90         Dave Lyons
0011 5C94              *
0012 5C94              * Changed rCtlColorTable to rCtlColorTbl.
0013 5C94              *
0014 5C94              * 26-Sep-90         Dave Lyons
0015 5C94              *
0016 5C94              * Now uses Get640Colors instead of having our own copy of color_patt (512 bytes).
0017 5C94              *
0018 5C94              * 27-Sep-90         Dave Lyons
0019 5C94              *
0020 5C94              * "If 0"-ed out experimental stuff from Harry that was trying to draw icons
0021 5C94              * in the pop-up result (and recalculate the control rect correspondingly).
0022 5C94              *
0023 5C94              * 21-Jan-91         Dave Lyons
0024 5C94              *
0025 5C94              * Adding ctlMoreFlags bit 7, fDrawArrowIcon, to draw a down-arrow icon after
0026 5C94              * a pop-up menu's currently-selected item.
0027 5C94              *
0028 5C94              * Adjusted the X coordinate to PopUpMenuSelect to make it line up right.
0029 5C94              *
0030 5C94              * 9-Mar-91          Dave Lyons
0031 5C94              *
0032 5C94              * Added check to make the popped-up menu be at least as wide as the non-popped-up
0033 5C94              * representation.  This is especially cool if there's a down-arrow icon on the
0034 5C94              * right, because it looks really stupid to have that hanging out to the side while
0035 5C94              * the menu is popped up.
0036 5C94              *
0037 5C94              * 15-Mar-91         Dave Lyons
0038 5C94              *
0039 5C94              * Added a missing call to derefMenuHand--the pop-up width stuff added above was
0040 5C94              * working sometimes, but not all the time.
0041 5C94              *
0042 5C94              * 2-Jul-91          Dave Lyons
0043 5C94              *
0044 5C94              * Changed GetOSIcon to GetSysIcon, removed macro.
0045 5C94              *
0046 5C94              * 7-Dec-91          Dave Lyons
0047 5C94              *
0048 5C94              * Added and then commented out code to disallow a pop-up to be set to
0049 5C94              *   a dimmed menu item.
0050 5C94              * Now releases rIcon resources to purge level 3 instead of -1.
0051 5C94              * SetCtlValue on a pop-up now draws the new value dimmed if the
0052 5C94              *   control is currently dimmed.
0053 5C94              *
0054 5C94              **********************************************************************
0055 5C94              *
0056 5C94              * 13-Mar-92         Dave Lyons for 6.1
0057 5C94              *
0058 5C94              * Use DrawStringWidth to draw the un-popped menu selection.
0059 5C94              * Minor optimizations (PEIs, ASL/LSR).
0060 5C94              *
0061 5C94              * 16-Mar-92         Dave Lyons
0062 5C94              *
0063 5C94              * Finished the DrawStringWidth mod in DrawResult (center truncate).
0064 5C94              * More optimizations.
0065 5C94              *
0066 5C94              * 17-Nov-92         Dave Lyons
0067 5C94              *
0068 5C94              * When handling a do_event message, only send keyDown and autoKey events
0069 5C94              * to MenuKey.  Preserve the menu bar around the MenuKey call, so we don't
0070 5C94              * accidentally leave the menu bar set to the pop-up menu control.
0071 5C94              *
0072 5C94              **********************************************************************
0073 5C94
0074 5C94                       ENTRY MoveRect 
0075 5C94                       ENTRY MoveRectIn 
0076 5C94                       ENTRY PushPtrToRect 
0077 5C94                       ENTRY PushPtrToRect2 
0078 5C94                       ENTRY DerefMenuHand 
0079 5C94                       ENTRY SetNewMenuBar 
0080 5C94                       ENTRY SetupColorTable 
0081 5C94                       ENTRY DrawPopUpBox 
0082 5C94                       ENTRY DefColorTable 
0083 5C94                       ENTRY Dimmed 
0084 5C94                       ENTRY Nor_Mask 
0085 5C94                       ENTRY DrawResult 
0086 5C94                       ENTRY ClearResult 
0087 5C94
0088 5C94
0089 5C94                       title 'PopUpDefProc -- MainEntry' 
0090 5C94
0091 5C94              ****************************************************************
0092 5C94              *
0093 5C94              PopUpProc PROC EXPORT 
0094 5C94              *
0095 5C94              * This is the def_proc for PopUp controls.  When this
0096 5C94              * routine gets control, the stack looks as described below.
0097 5C94              *
0098 5C94              *
0099 5C94              *
0100 5C94              * Inputs:           On entry, the parameters are passed to us on the stack.
0101 5C94              *
0102 5C94              *                   |                   | Previous Contents
0103 5C94              *                   |-------------------|
0104 5C94              *                   |    ReturnValue    | LONG - Space for return value
0105 5C94              *                   |-------------------|
0106 5C94              *                   |    CtlCode        | WORD - operation to perform
0107 5C94              *                   |-------------------|
0108 5C94              *                   |    CtlParam       | LONG - add'l parameter
0109 5C94              *                   |-------------------|
0110 5C94              *                   |    theCtlHandle   | LONG - Handle to control record
0111 5C94              *                   |-------------------|
0112 5C94              *                   |    RtnAddr        | 3 BYTES - RTL address
0113 5C94              *                   |-------------------|
0114 5C94              *                   |                   | <-- Stack pointer
0115 5C94              *
0116 5C94              * Outputs:          Put something into ReturnValue, pull off the parameters,
0117 5C94              *                   and return to the Control Manager.
0118 5C94              *
0119 5C94              *                   |                   | Previous Contents
0120 5C94              *                   |-------------------|
0121 5C94              *                   |    ReturnValue    | LONG - Space for return value
0122 5C94              *                   |-------------------|
0123 5C94              *                   |    RtnAddr        | 3 BYTES - RTL address
0124 5C94              *                   |-------------------|
0125 5C94              *                   |                   | <-- Stack pointer
0126 5C94              *
0127 5C94              * External Refs:
0128 5C94                       import do_draw 
0129 5C94                       import do_nothing 
0130 5C94                       import do_disposePopUp 
0131 5C94                       import do_test 
0132 5C94                       import do_init 
0133 5C94                       import do_newvalue 
0134 5C94                       import do_track 
0135 5C94                       import do_move 
0136 5C94                       import do_recsize 
0137 5C94                       import do_key 
0138 5C94                       import do_stateChange 
0139 5C94                       import SelfMod1Low 
0140 5C94                       import SelfMod1High 
0141 5C94                       import SelfMod2Low 
0142 5C94                       import SelfMod2High 
0143 5C94                       import SelfMod3Low 
0144 5C94                       import SelfMod3High 
0145 5C94              *
0146 5C94              * Entry Points:
0147 5C94              *                   none
0148 5C94              *
0149 5C94                       longa on                       ; mode
0150 5C94                       longi on
0151 5C94              *
0152 5C94              ****************************************************************
0153 5C94
0154 5C94 8B                    phb                            ; save the Data Bank register
0155 5C95 0B                    phd                            ; save the Direct Page register
0156 5C96
0157 5C96 4B                    phk                            ; switch data bank to program bank
0158 5C97 AB                    plb   
0159 5C98
0160 5C98              *** added 26-Sep-90 DAL (self-mod references to color_patt once)
0161 5C98
0162 5C98 A9 00 00     @flag    lda   #0
0163 5C9B D0 20                 bne   @done
0164 5C9D EE 99 5F              inc   @flag+1
0165 5CA0 48                    pha   
0166 5CA1 48                    pha   
0167 5CA2 A2 04 DA 22           _Get640Colors 
0168 5CA9 68                    pla   
0169 5CAA 8D D8 62              sta   SelfMod1Low+1
0170 5CAD 8D 06 68              sta   SelfMod2Low+1
0171 5CB0 8D 9F 68              sta   SelfMod3Low+1
0172 5CB3 68                    pla   
0173 5CB4 8D CF 62              sta   SelfMod1High+1
0174 5CB7 8D FA 67              sta   SelfMod2High+1
0175 5CBA 8D 96 68              sta   SelfMod3High+1
0176 5CBD              @done     
0177 5CBD              *** end of 26-Sep-90 addition
0178 5CBD
0179 5CBD 3B                    tsc   
0180 5CBE 38                    sec   
0181 5CBF E9 1E 00              sbc   #ZPageSize
0182 5CC2 1B                    tcs                            ; switch Direct Page into stack
0183 5CC3 5B                    tcd   
0184 5CC4
0185 5CC4 A5 2D                 lda   <CtlCode
0186 5CC6 C9 0C 00              cmp   #recSize
0187 5CC9 F0 15                 beq   SkipDeref
0188 5CCB
0189 5CCB A0 04 00              ldy   #4
0190 5CCE B7 25                 lda   [<theCtlHandle],y
0191 5CD0 09 00 80              ora   #$8000                   ; lock the handle
0192 5CD3 97 25                 sta   [<theCtlHandle],y
0193 5CD5
0194 5CD5 A7 25                 lda   [<theCtlHandle]          ; dereference the handle
0195 5CD7 85 05                 sta   <CtlPtr
0196 5CD9 A0 02 00              ldy   #2
0197 5CDC B7 25                 lda   [<theCtlHandle],y
0198 5CDE 85 07                 sta   <CtlPtr+2
0199 5CE0
0200 5CE0 A5 2D        SkipDeref lda   <CtlCode                ; get routine # to call
0201 5CE2 C9 14 00              cmp   #MaxMessages+1
0202 5CE5 90 03                 blt   ShiftIt
0203 5CE7 A9 06 00              lda   #6                       ; force unknown codes to null events
0204 5CEA              ShiftIt   
0205 5CEA 0A                    asl   a
0206 5CEB AA                    tax   
0207 5CEC FC 1D 60              jsr   (ActionTable,x)
0208 5CEF
0209 5CEF 85 2F                 sta   <ReturnValue             ; save the return value
0210 5CF1 86 31                 stx   <ReturnValue+2
0211 5CF3
0212 5CF3 A5 2D                 lda   <CtlCode
0213 5CF5 C9 0C 00              cmp   #recsize
0214 5CF8 F0 09                 beq   SkipUnlock
0215 5CFA
0216 5CFA A0 04 00              ldy   #4                       ; unlock the control handle
0217 5CFD B7 25                 lda   [<theCtlHandle],y
0218 5CFF              ;	and	#$7FFF
0219 5CFF 0A                    asl   a
0220 5D00 4A                    lsr   a
0221 5D01 97 25                 sta   [<theCtlHandle],y
0222 5D03
0223 5D03 3B           SkipUnlock tsc   
0224 5D04 18                    clc   
0225 5D05 69 1E 00              adc   #ZPageSize
0226 5D08 1B                    tcs   
0227 5D09
0228 5D09 A5 22                 lda   <RtnAddr                 ; move the return address up
0229 5D0B 85 2C                 sta   <ReturnValue-3
0230 5D0D A5 23                 lda   <RtnAddr+1
0231 5D0F 85 2D                 sta   <ReturnValue-2
0232 5D11
0233 5D11 2B                    pld                            ; restore caller's Data Bank and
0234 5D12 AB                    plb                            ; Direct Page registers
0235 5D13
0236 5D13 68                    pla                            ; remove 10 bytes
0237 5D14 68                    pla   
0238 5D15 68                    pla   
0239 5D16 68                    pla   
0240 5D17 68                    pla   
0241 5D18
0242 5D18 A9 00 00              lda   #0
0243 5D1B 18                    clc   
0244 5D1C
0245 5D1C 6B                    rtl                            ; back to the caller
0246 5D1D
0247 5D1D              ;
0248 5D1D 5D 62        ActionTable DC W:do_draw                0 Draw simple button.
0249 5D1F 4C 60                 DC W:do_nothing                1 Compute drag RECT.
0250 5D21 32 62                 DC W:do_test                   2 Common hit test routine.
0251 5D23 51 60                 DC W:do_init                   3 Initialize the control.
0252 5D25 FC 61                 DC W:do_disposePopUp           4 Dispose.
0253 5D27 5D 62                 DC W:do_draw                   5 New value.
0254 5D29 4C 60                 DC W:do_nothing                6 Compute Thumber constrains.
0255 5D2B 2E 63                 DC W:do_track                  7 Drag the indicator.
0256 5D2D 4C 60                 DC W:do_nothing                8 Auto action.
0257 5D2F F0 62                 DC W:do_newvalue               9 New value.
0258 5D31 4C 60                 DC W:do_nothing                10 Set min max.
0259 5D33 53 64                 DC W:do_move                   11 Move button.
0260 5D35 45 60                 DC W:do_recsize                12 Return size of standard record.
0261 5D37 69 64                 DC W:do_key                    13 take key or menu event
0262 5D39 4C 60                 DC W:do_nothing                14 ctlChangeTarget
0263 5D3B 4C 60                 DC W:do_nothing                15 ctlChangeBounds
0264 5D3D 4C 60                 DC W:do_nothing                16 ctlWindChangeSize
0265 5D3F 4C 60                 DC W:do_nothing                17 ctlHandleTab
0266 5D41 4C 60                 DC W:do_nothing                18 ctlHideCntl
0267 5D43 F1 64                 DC W:do_StateChange            19 ctlWindStateChange, tells us state of control changed
0268 5D45                       ENDP 
0269 5D45
0270 5D45
0271 5D45                       title 'PopUpDefProc -- do_recsize' 
0272 5D45              ****************************************************************
0273 5D45              *
0274 5D45              do_recsize PROC 
0275 5D45              *
0276 5D45              * Returns the size of the control record.
0277 5D45              *
0278 5D45              *
0279 5D45              * Inputs:
0280 5D45              *                   none
0281 5D45              *
0282 5D45              * Outputs:
0283 5D45              *                   a-reg & x-reg hold result for def proc
0284 5D45              *
0285 5D45              * External Refs:
0286 5D45              *                   none
0287 5D45              *
0288 5D45              * Entry Points:
0289 5D45              *                   none
0290 5D45              *
0291 5D45                       longa on                       ; mode
0292 5D45                       longi on
0293 5D45              *
0294 5D45              ****************************************************************
0295 5D45
0296 5D45 A9 42 00              lda   #PopUpCtlRecord.Size
0297 5D48 A2 00 00              ldx   #0                       High word of size.
0298 5D4B
0299 5D4B 60                    rts   
0300 5D4C
0301 5D4C                       ENDP 
0302 5D4C
0303 5D4C
0304 5D4C                       title 'PopUpDefProc -- Do_Nothing' 
0305 5D4C              ****************************************************************
0306 5D4C              *
0307 5D4C              do_nothing PROC 
0308 5D4C              *
0309 5D4C              * This is the routine we use when there is nothing to do.
0310 5D4C              * It just returns zeros in the a and x registers.
0311 5D4C              *
0312 5D4C              *
0313 5D4C              * Inputs:
0314 5D4C              *                   ctlHandle
0315 5D4C              *                   ctlPtr
0316 5D4C              *
0317 5D4C              * Outputs:
0318 5D4C              *                   a-reg & x-reg hold result for def proc
0319 5D4C              *
0320 5D4C              * External Refs:
0321 5D4C              *                   none
0322 5D4C              *
0323 5D4C              * Entry Points:
0324 5D4C              *                   none
0325 5D4C              *
0326 5D4C                       longa on                       ; mode
0327 5D4C                       longi on
0328 5D4C              *
0329 5D4C              ****************************************************************
0330 5D4C
0331 5D4C A9 00 00              lda   #0                       Nothing flag.
0332 5D4F AA                    tax   
0333 5D50
0334 5D50 60                    rts   
0335 5D51
0336 5D51                       ENDP 
0337 5D51
0338 5D51
0339 5D51                       title 'PopUpDefProc -- Do_Init' 
0340 5D51              ;=======================================================================
0341 5D51              ;
0342 5D51              ;                   Do_Init
0343 5D51              ;
0344 5D51              ; Initialize a bunch of things and copy the pop-up template data into the
0345 5D51              ; control record.
0346 5D51              ;
0347 5D51              ; Do_Init copies various fields from the PopUpTemplate to the Control Record.
0348 5D51              ; The fields ID, Rect, ProcRef, Flags, MoreFlags and RefCon are automatically
0349 5D51              ; copied from our template to the control record by the control manager.
0350 5D51              ;
0351 5D51              ; The main thing this routine does is calculate the pop-up's rect and the true
0352 5D51              ; control rect depending on what the titlewidth is set.
0353 5D51              ;
0354 5D51              ;=======================================================================
0355 5D51              do_init  PROC 
0356 5D51
0357 5D51                       longa on                       ; mode
0358 5D51                       longi on
0359 5D51
0360 5D51              fontheight equ   word1                  ; redefine some direct page locations
0361 5D51              descent  equ   word2
0362 5D51              widmax   equ   word3
0363 5D51              leading  equ   word4
0364 5D51              title_width equ   word5
0365 5D51
0366 5D51                       WITH PopUpCtlRecord 
0367 5D51
0368 5D51 48                    pha                            ; space for handle from one of the
0369 5D52 48                    pha                            ; newmenu calls
0370 5D53
0371 5D53 A0 14 00              ldy   #PopUpTemplate.MoreFlags ; first find out what format the
0372 5D56 B7 29                 lda   [<ctlparam],y            ; menu is in, text stream or template
0373 5D58 29 04 00              and   #FMenuDefIsText          ; call NewMenu for text stream,
0374 5D5B D0 1A                 bne   CallNewMenu              ; NewMenu2 for template
0375 5D5D
0376 5D5D B7 29                 lda   [<ctlparam],y
0377 5D5F 29 03 00              and   #$0003                   ; menu is in format of MenuTemplate
0378 5D62 48                    pha                            ; get verb to find out whether menu is
0379 5D63 A0 1E 00              ldy   #PopUpTemplate.MenuRef+2 ; a ptr, handle, or resource ID
0380 5D66 B7 29                 lda   [<ctlparam],y
0381 5D68 48                    pha                            ; reference to MenuTemplate
0382 5D69 88                    dey   
0383 5D6A 88                    dey   
0384 5D6B B7 29                 lda   [<ctlparam],y
0385 5D6D 48                    pha                            ; copies MenuTemplate, into a
0386 5D6E A2 0F 3E 22           _NewMenu2                      ; menu record returning handle to it
0387 5D75
0388 5D75 80 12                 bra   getmenuHand
0389 5D77
0390 5D77 A0 1E 00     CallNewMenu ldy   #PopUpTemplate.MenuRef+2 ; pointer to an array of menu lines and
0391 5D7A B7 29                 lda   [<ctlparam],y            ; item lines
0392 5D7C 48                    pha   
0393 5D7D 88                    dey   
0394 5D7E 88                    dey   
0395 5D7F B7 29                 lda   [<ctlparam],y
0396 5D81 48                    pha                            ; let menu mgr parse our menu item list
0397 5D82 A2 0F 2D 22           _NewMenu                       ; create menu record and return handle to it
0398 5D89
0399 5D89 A0 28 00     getmenuHand ldy   #PopUpCtlRecord.MenuRef
0400 5D8C 68                    pla   
0401 5D8D 97 05                 sta   [<ctlPtr],y              ; store the menu handle in our control
0402 5D8F C8                    iny                            ; record
0403 5D90 C8                    iny   
0404 5D91 68                    pla   
0405 5D92 97 05                 sta   [<ctlPtr],y
0406 5D94
0407 5D94 A0 2C 00              ldy   #MenuEnd                 ; must zero out the next four bytes after the location
0408 5D97 A9 00 00              lda   #0                       ; where the menu ref is stored in the control record
0409 5D9A 97 05                 sta   [<ctlPtr],y              ; remember, our control record has the same structure as
0410 5D9C C8                    iny                            ; a menu bar record, so menuEnd signifies end of menu list
0411 5D9D C8                    iny   
0412 5D9E 97 05                 sta   [<ctlPtr],y
0413 5DA0
0414 5DA0              ;
0415 5DA0              ; calculate the width of the pop-up's title
0416 5DA0              ;
0417 5DA0 A0 12 00              ldy   #PopUpTemplate.Flags
0418 5DA3 B7 29                 lda   [<ctlparam],y
0419 5DA5 AA                    tax   
0420 5DA6 29 10 00              and   #FDontDrawTitle          ; first check if FDontDrawTitle flag is set, if it is then
0421 5DA9 F0 05                 beq   @888                     ; title width is zero
0422 5DAB A9 00 00              lda   #0
0423 5DAE 80 4C                 bra   storeTitleWidth
0424 5DB0
0425 5DB0 A0 1A 00     @888     ldy   #PopUpTemplate.TitleWidth
0426 5DB3 B7 29                 lda   [<ctlparam],y            ; now check if app has specifically set a title width
0427 5DB5 F0 0A                 beq   @999                     ; if they have then use this width only if title left just.
0428 5DB7 A8                    tay                            ; save title width app has set
0429 5DB8 8A                    txa                            ; remember moreFlags still in x-reg
0430 5DB9 29 02 00              and   #FRightJustifyTitle
0431 5DBC D0 03                 bne   @999
0432 5DBE 98                    tya   
0433 5DBF 80 3B                 bra   storeTitleWidth
0434 5DC1
0435 5DC1 48           @999     pha                            ; space for StringWidth call
0436 5DC2
0437 5DC2 48                    pha                            ; space for ptr to menu title
0438 5DC3 48                    pha   
0439 5DC4 A0 2A 00              ldy   #PopUpCtlRecord.MenuRef+2
0440 5DC7 B7 05                 lda   [<ctlPtr],y
0441 5DC9 48                    pha   
0442 5DCA 88                    dey   
0443 5DCB 88                    dey   
0444 5DCC B7 05                 lda   [<ctlPtr],y              ; this routine checks to see if the menu title ref
0445 5DCE 48                    pha                            ; is a ptr, handle, or resource ID  and
0446 5DCF A2 0F 44 22           _GetResMTitle                  ; returns ptr (pascal string) to the menu title
0447 5DD6 A3 01                 lda   1,s                      ; check if the title is the apple logo
0448 5DD8 85 01                 sta   <temp
0449 5DDA A3 03                 lda   3,s
0450 5DDC 85 03                 sta   <temp+2
0451 5DDE A7 01                 lda   [<temp]
0452 5DE0 C9 01 40              cmp   #$4001
0453 5DE3 F0 05                 beq   ItsTheAppleLogo
0454 5DE5 C9 01 FF              cmp   #$FF01
0455 5DE8 D0 09                 bne   NotAppleLogo
0456 5DEA
0457 5DEA 68           ItsTheAppleLogo pla                     ; get ptr to title off the stack
0458 5DEB 68                    pla   
0459 5DEC A9 18 00              lda   #24                      ; width of apple logo
0460 5DEF 83 01                 sta   1,s
0461 5DF1 80 0A                 bra   GotWidth
0462 5DF3
0463 5DF3 A2 04 A9 22  NotAppleLogo _StringWidth 
0464 5DFA 80 01                 bra   GotWidth
0465 5DFC
0466 5DFC 48           storeTitleWidth pha   
0467 5DFD 20 0F 65     GotWidth jsr   derefmenuhand
0468 5E00 68                    pla   
0469 5E01 A0 0E 00              ldy   #oTitleWidth
0470 5E04 97 01                 sta   [<temp],y
0471 5E06
0472 5E06 A0 0A 00              ldy   #oMenuFlag
0473 5E09 B7 01                 lda   [<temp],y
0474 5E0B 29 F7 FF              and   #_M_CACHE                ; pop-up menus cannont be cached
0475 5E0E 09 01 00              ora   #M_POPUP                 ; set the flag in menu that says menu is a pop-up
0476 5E11 97 01                 sta   [<temp],y
0477 5E13
0478 5E13              ;==================================================
0479 5E13              ;
0480 5E13              ; Initialize some rects and calc a bunch of stuff
0481 5E13              ;
0482 5E13
0483 5E13              ; first check to see if the user wants me to calculate the bottom right bounds of the
0484 5E13              ; control rect for them
0485 5E13
0486 5E13 A0 08 00              ldy   #ctlRect                 ; move the current control record into our direct page
0487 5E16 20 DB 68              jsr   MoveRect                 ; so we can get to it easier
0488 5E19
0489 5E19 A5 0D                 lda   <rect+y2                 ; is bottom of rect defined?
0490 5E1B D0 24                 bne   BottomDefined
0491 5E1D
0492 5E1D F4 00 00              pea   0                        ; get current font size and calculate height of our pop-up
0493 5E20 7B                    tdc                            ; space for font info record is on the stack
0494 5E21 18                    clc   
0495 5E22 69 11 00              adc   #fontHeight
0496 5E25 48                    pha   
0497 5E26 A2 04 96 22           _GetFontInfo 
0498 5E2D
0499 5E2D A5 13                 lda   <descent                 ; get font height and add in some slop
0500 5E2F 18                    clc   
0501 5E30 69 02 00              adc   #B_LEADING
0502 5E33 85 13                 sta   <descent
0503 5E35
0504 5E35 18                    clc   
0505 5E36 65 11                 adc   <fontHeight
0506 5E38 69 02 00              adc   #T_LEADING
0507 5E3B 85 11                 sta   <fontHeight
0508 5E3D
0509 5E3D 65 09                 adc   <rect+y1                 ; we now have a new bottom
0510 5E3F 85 0D                 sta   <rect+y2
0511 5E41
0512 5E41              BottomDefined  
0513 5E41
0514 5E41              ;------------------------------------------------------------
0515 5E41              ; now we check the right side of the pop-up
0516 5E41              ; right = length of title plus length of pop-up box
0517 5E41              ;      length of title = actual length of title string or TitleWidth if non-zero
0518 5E41              ;      length of pop-up = widest item in menu or whatever user as defined for right side
0519 5E41
0520 5E41 A5 0F                 lda   <rect+x2                 ; use apps right side?
0521 5E43 D0 4B                 bne   RightDefined
0522 5E45
0523 5E45 20 C0 68              jsr   setNewMenuBar            ; switch menu bars, orig menu bar is put on stack
0524 5E48
0525 5E48 20 0F 65              jsr   derefmenuhand
0526 5E4B
0527 5E4B F4 00 00              pea   0                        ; new width, 0 for automatic calculation
0528 5E4E F4 00 00              pea   0                        ; new heighth, 0 for automatic calculation
0529 5E51              ***	ldy	#oMenuID	; id of menu record (ZERO)
0530 5E51 A7 01                 lda   [<temp]
0531 5E53 48                    pha   
0532 5E54 A2 0F 1C 22           _CalcMenuSize                  ; let the menu manager calculate widest item in the menu
0533 5E5B
0534 5E5B 20 0F 65              jsr   derefmenuhand
0535 5E5E
0536 5E5E A2 0F 39 22           _SetMenuBar                    ; restore original menu Bar
0537 5E65
0538 5E65 20 0F 65              jsr   derefmenuhand            ; deref menu handle one more time just in case it moved
0539 5E68
0540 5E68 A0 1A 00              ldy   #PopUpTemplate.TitleWidth
0541 5E6B B7 29                 lda   [<ctlparam],y            ; see if title width as been pre-defined
0542 5E6D D0 05                 bne   @777                     ; if it has use it, else get the titlewidth we
0543 5E6F                                                      ; calculated above
0544 5E6F A0 0E 00              ldy   #oTitleWidth
0545 5E72 B7 01                 lda   [<temp],y
0546 5E74
0547 5E74 A0 02 00     @777     ldy   #oMenuWidth              ; get width of widest item in menu
0548 5E77 18                    clc   
0549 5E78 77 01                 adc   [<temp],y                ; add to width of pop-up's title to get right coordinate
0550 5E7A
0551 5E7A              *** Added 21-Jan-91 DAL
0552 5E7A              *** Allow 22 pixels of width for the down-arrow icon, if we're drawing one
0553 5E7A 48                    pha   
0554 5E7B A0 3C 00              ldy   #PopUpCtlRecord.ctlMoreFlags
0555 5E7E B7 05                 lda   [<ctlPtr],y
0556 5E80 29 80 00              and   #fDrawArrowIcon
0557 5E83 F0 06                 beq   @noAdjust
0558 5E85 68                    pla   
0559 5E86 18                    clc   
0560 5E87 69 16 00              adc   #22
0561 5E8A 48                    pha   
0562 5E8B 68           @noAdjust pla   
0563 5E8C              *** end of 21-Jan-91 DAL
0564 5E8C
0565 5E8C 65 0B                 adc   <rect+x1
0566 5E8E 85 0F                 sta   <rect+x2
0567 5E90
0568 5E90 E6 0D        RightDefined inc   <rect+y2             ; we must account for the bottom drop shadow
0569 5E92 A0 30 00              ldy   #PopUpRect               ; now we define our popup rectangle, initially pop-up rect
0570 5E95 20 EC 68              jsr   moveRectIn               ; equals the rect of whole control
0571 5E98
0572 5E98 A0 1A 00              ldy   #PopUpTemplate.TitleWidth
0573 5E9B B7 29                 lda   [<ctlparam],y            ; check if app has pre-defined the title width
0574 5E9D D0 05                 bne   @666                     ; if it has use it, else get width we calc. above
0575 5E9F
0576 5E9F A0 0E 00              ldy   #oTitleWidth
0577 5EA2 B7 01                 lda   [<temp],y
0578 5EA4
0579 5EA4 18           @666     clc   
0580 5EA5 65 0B                 adc   <rect+x1
0581 5EA7 A0 32 00              ldy   #PopUpRect+x1            ; now plug in the real left coordinate for the pop-up rect
0582 5EAA 97 05                 sta   [<ctlPtr],y
0583 5EAC
0584 5EAC A0 0E 00              ldy   #oTitleWidth             ; just in case app wanted title right justified
0585 5EAF 38                    sec                            ; we have to adjust left coord. of our control rect.
0586 5EB0 F7 01                 sbc   [<temp],y
0587 5EB2 85 0B                 sta   <rect+x1
0588 5EB4
0589 5EB4 A0 08 00              ldy   #ctlRect
0590 5EB7 20 EC 68              jsr   MoveRectIn
0591 5EBA
0592 5EBA A0 00 00              ldy   #PopUpTemplate.pCount
0593 5EBD B7 29                 lda   [<ctlparam],y
0594 5EBF C9 08 00              cmp   #8
0595 5EC2 F0 07                 beq   NoInitialValue
0596 5EC4
0597 5EC4 A0 20 00              ldy   #PopUpTemplate.InitialValue ; get initial value of current selection
0598 5EC7 B7 29                 lda   [<ctlparam],y            ; for the pop-up and store in control rec
0599 5EC9 80 03                 bra   storevalue
0600 5ECB
0601 5ECB A9 00 00     NoInitialValue lda   #0
0602 5ECE
0603 5ECE A0 12 00     storevalue ldy   #PopUpCtlRecord.ctlValue
0604 5ED1 97 05                 sta   [<ctlPtr],y
0605 5ED3
0606 5ED3 A0 00 00              ldy   #PopUpTemplate.pCount
0607 5ED6 B7 29                 lda   [<ctlparam],y
0608 5ED8 C9 09 00              cmp   #9
0609 5EDB F0 0C                 beq   doDefault
0610 5EDD
0611 5EDD A0 22 00              ldy   #PopUpTemplate.ColorTableRef
0612 5EE0 B7 29                 lda   [<ctlparam],y
0613 5EE2 AA                    tax   
0614 5EE3 C8                    iny   
0615 5EE4 C8                    iny   
0616 5EE5 B7 29                 lda   [<ctlParam],y
0617 5EE7 80 04                 bra   storeIt
0618 5EE9
0619 5EE9 A9 00 00     doDefault lda   #0                      ; Zero for default color table
0620 5EEC AA                    tax   
0621 5EED
0622 5EED A0 26 00     storeIt  ldy   #ctlColor+2
0623 5EF0 97 05                 sta   [<ctlPtr],y              ; high word of color table
0624 5EF2 88                    dey   
0625 5EF3 88                    dey   
0626 5EF4 8A                    txa                            ; x contains low word of color table
0627 5EF5 97 05                 sta   [<ctlPtr],y
0628 5EF7
0629 5EF7                       ENDWITH 
0630 5EF7
0631 5EF7 A9 00 00              lda   #0
0632 5EFA AA                    tax   
0633 5EFB 60                    rts   
0634 5EFC
0635 5EFC                       ENDP 
0636 5EFC
0637 5EFC
0638 5EFC                       title 'PopUpDefProc -- do_disposePopUp' 
0639 5EFC              ****************************************************************
0640 5EFC              *
0641 5EFC              do_disposePopUp PROC EXPORT 
0642 5EFC              *
0643 5EFC              * Test if the mouse is down in the control.
0644 5EFC              *
0645 5EFC              *
0646 5EFC              * Inputs:
0647 5EFC              *                   ctlParam = undefined
0648 5EFC              *
0649 5EFC              *
0650 5EFC              * Outputs:
0651 5EFC              *                   a-reg and x-reg are always zero
0652 5EFC              *
0653 5EFC              * External Refs:
0654 5EFC              *                   none
0655 5EFC              *
0656 5EFC              * Entry Points:
0657 5EFC              *                   none
0658 5EFC              *
0659 5EFC                       longa on                       ; mode
0660 5EFC                       longi on
0661 5EFC              *
0662 5EFC              ****************************************************************
0663 5EFC
0664 5EFC A0 2A 00              ldy   #PopUpCtlRecord.MenuRef+2
0665 5EFF B7 05                 lda   [<ctlPtr],y
0666 5F01 48                    pha   
0667 5F02 88                    dey   
0668 5F03 88                    dey   
0669 5F04 B7 05                 lda   [<ctlPtr],y
0670 5F06 48                    pha   
0671 5F07 A2 02 10 22           _DisposeHandle 
0672 5F0E
0673 5F0E A0 3C 00              ldy   #PopUpCtlRecord.ctlmoreflags
0674 5F11 B7 05                 lda   [<ctlPtr],y
0675 5F13 29 10 00              and   #$0010                   ; is the color table a resource
0676 5F16 F0 15                 beq   NotResource
0677 5F18
0678 5F18 F4 0D 80              PushWord #rCtlColorTbl         ;was rCtlColorTable 17-Sep-90 DAL
0679 5F1B A0 26 00              ldy   #PopUpCtlRecord.ctlColor+2
0680 5F1E B7 05                 lda   [<ctlPtr],y
0681 5F20 48                    pha   
0682 5F21 88                    dey   
0683 5F22 88                    dey   
0684 5F23 B7 05                 lda   [<ctlPtr],y
0685 5F25 48                    pha   
0686 5F26 A2 10 33 22           _CMReleaseResource 
0687 5F2D
0688 5F2D              NotResource  
0689 5F2D A9 00 00              lda   #0
0690 5F30 AA                    tax   
0691 5F31
0692 5F31 60                    rts   
0693 5F32
0694 5F32                       ENDP 
0695 5F32
0696 5F32
0697 5F32                       title 'PopUpDefProc -- do_test' 
0698 5F32              ****************************************************************
0699 5F32              *
0700 5F32              do_test  PROC 
0701 5F32              *
0702 5F32              * Test if the mouse is down in the control.
0703 5F32              *
0704 5F32              *
0705 5F32              * Inputs:
0706 5F32              *                   ctlParam = point to check
0707 5F32              *
0708 5F32              *
0709 5F32              * Outputs:
0710 5F32              *                   a-reg and x-reg are always zero
0711 5F32              *
0712 5F32              * External Refs:
0713 5F32              *                   none
0714 5F32              *
0715 5F32              * Entry Points:
0716 5F32              *                   none
0717 5F32              *
0718 5F32                       longa on                       ; mode
0719 5F32                       longi on
0720 5F32              *
0721 5F32              ****************************************************************
0722 5F32
0723 5F32 48                    pha                            ; space for result
0724 5F33 F4 00 00              pea   0000                     ; push pointer to point to check
0725 5F36 7B                    tdc   
0726 5F37 18                    clc   
0727 5F38 69 29 00              adc   #ctlparam
0728 5F3B 48                    pha   
0729 5F3C A0 08 00              ldy   #PopUpCtlRecord.CtlRect
0730 5F3F 20 DB 68              jsr   MoveRect                 ; push ptr to the control rectangle
0731 5F42 C6 0D                 dec   <rect+y2                 ; bottom drop shadow is not part of "hot spot"
0732 5F44 20 FD 68              jsr   PushPtrToRect
0733 5F47 A2 04 4F 22           _PtInRect                      ; is mouse in the pop-up control's rect
0734 5F4E 68                    pla   
0735 5F4F F0 05                 beq   Ignore
0736 5F51
0737 5F51 A9 A0 00              lda   #$A0
0738 5F54 80 03                 bra   GetOut
0739 5F56
0740 5F56 A9 00 00     Ignore   lda   #0                       Return that we want to ignore this.
0741 5F59
0742 5F59 A2 00 00     GetOut   ldx   #0                       high word zero
0743 5F5C
0744 5F5C 60                    rts   
0745 5F5D
0746 5F5D                       ENDP 
0747 5F5D
0748 5F5D
0749 5F5D                       title 'PopUpDefProc -- Do_Draw' 
0750 5F5D              ****************************************************************
0751 5F5D              *
0752 5F5D              do_draw  PROC 
0753 5F5D              *
0754 5F5D              * Draws the control using DrawPopUp.
0755 5F5D              *
0756 5F5D              *
0757 5F5D              * Inputs:
0758 5F5D              *                   ctlHandle
0759 5F5D              *                   ctlPtr
0760 5F5D              *                   ctlParam = high-order word tells us if control is active or not, $FFFF=not active
0761 5F5D              *                              low-order word = part code.
0762 5F5D              *
0763 5F5D              * Outputs:
0764 5F5D              *                   a-reg and x-reg are zero.
0765 5F5D              *
0766 5F5D              * External Refs:
0767 5F5D                       import LoadResource 
0768 5F5D              *
0769 5F5D              * Entry Points:
0770 5F5D              *                   none
0771 5F5D              *
0772 5F5D                       longa on                       ; mode
0773 5F5D                       longi on
0774 5F5D              *
0775 5F5D              ****************************************************************
0776 5F5D                       WITH PopUpCtlRecord 
0777 5F5D
0778 5F5D              Mode     equ   word7
0779 5F5D
0780 5F5D A0 10 00              ldy   #ctlFlag                 ; check if the invisible flag is set
0781 5F60 B7 05                 lda   [<ctlPtr],y
0782 5F62 29 80 00              and   #$0080                   ; if high bit of flag is set then its invisible
0783 5F65 F0 03                 beq   notInvisible
0784 5F67 82 48 00              brl   noDraw
0785 5F6A
0786 5F6A 48           notInvisible pha                        ; find out what mode we're in first
0787 5F6B A2 04 17 22           _GetMasterSCB 
0788 5F72 68                    pla   
0789 5F73 29 80 00              and   #$0080
0790 5F76 85 1D                 sta   <mode
0791 5F78
0792 5F78 20 C0 68              jsr   setNewMenuBar            ; set menu bar to the control handle, old menu bar
0793 5F7B                                                      ; handle is still on the stack
0794 5F7B 20 29 65              jsr   SetupColorTable          ; set up color table and put in <word1
0795 5F7E
0796 5F7E A0 10 00              ldy   #ctlflag                 ; first check if we need to draw a title
0797 5F81 B7 05                 lda   [<ctlPtr],y
0798 5F83 29 10 00              and   #FDontDrawTitle
0799 5F86 D0 13                 bne   NoTitle
0800 5F88
0801 5F88 20 0F 65              jsr   derefmenuhand            ; deref handle to menu and put in <temp
0802 5F8B
0803 5F8B F4 00 00              pea   0                        ; draw the pop-up's title
0804 5F8E A0 00 00              ldy   #oMenuID
0805 5F91 B7 01                 lda   [<temp],y
0806 5F93 48                    pha   
0807 5F94 A2 0F 2C 22           _HiliteMenu 
0808 5F9B
0809 5F9B 20 E3 67     NoTitle  jsr   DrawPopUpBox             ; draw pop-up box and drop shadow
0810 5F9E
0811 5F9E A2 00 00              ldx   #0                       ; flag for DrawResult that says PopUpBox was also drawn
0812 5FA1                                                      ; this flag tells us we don't have to do some extra setup
0813 5FA1                                                      ; work already done in DrawPopUpBox
0814 5FA1 20 80 65              jsr   DrawResult               ; draw current selection in pop-up box
0815 5FA4
0816 5FA4 A5 2B                 lda   <ctlParam+2
0817 5FA6 10 03                 bpl   active
0818 5FA8
0819 5FA8              *** subrootinized 7-Dec-91 DAL
0820 5FA8 20 B7 62              jsr   DimMyRectangle
0821 5FAB              ***
0822 5FAB
0823 5FAB A2 0F 39 22  active   _SetMenuBar                    ; restore original system menu bar
0824 5FB2 A9 00 00     noDraw   lda   #0
0825 5FB5 AA                    tax   
0826 5FB6
0827 5FB6 60                    rts   
0828 5FB7
0829 5FB7              *** subrootinized 7-Dec-91 DAL
0830 5FB7                       export DimMyRectangle 
0831 5FB7 F4 02 00     DimMyRectangle pea   dimmed>>16
0832 5FBA F4 18 69              pea   dimmed
0833 5FBD A2 04 32 22           _SetPenMask 
0834 5FC4
0835 5FC4 A0 0A 00              ldy   #PopUpCtlRecord.CtlRect+x1
0836 5FC7 B7 05                 lda   [<ctlPtr],y
0837 5FC9 85 0B                 sta   <rect+x1
0838 5FCB 20 FD 68              jsr   PushPtrToRect
0839 5FCE              ***	pea	color_patt>>16
0840 5FCE                       entry SelfMod1High 
0841 5FCE F4 77 77     SelfMod1High pea   $7777                ;26-Sep-90 DAL
0842 5FD1 A7 11                 lda   [<word1]
0843 5FD3 29 F0 00              and   #$00F0
0844 5FD6 0A                    asl   a
0845 5FD7              ***	adc	#color_patt
0846 5FD7                       entry SelfMod1Low 
0847 5FD7 69 77 77     SelfMod1Low adc   #$7777                ;26-Sep-90 DAL
0848 5FDA 48                    pha   
0849 5FDB A2 04 57 22           _FillRect 
0850 5FE2
0851 5FE2 F4 02 00              pea   nor_mask>>16
0852 5FE5 F4 20 69              pea   nor_mask
0853 5FE8 A2 04 32 22           _SetPenMask                    ; restore pen mask
0854 5FEF 60                    rts   
0855 5FF0              *** end of subrootinization, 7-Dec-91
0856 5FF0
0857 5FF0                       ENDWITH 
0858 5FF0
0859 5FF0                       ENDP 
0860 5FF0
0861 5FF0                       title 'PopUpDefProc -- Do_NewValue' 
0862 5FF0              ****************************************************************
0863 5FF0              *
0864 5FF0              do_newValue PROC 
0865 5FF0              *
0866 5FF0              * Called by control manager in response to a _SetCtlValue call. This routine redraws the
0867 5FF0              * result in the pop-up in response to a change in the selected item for the pop-up.
0868 5FF0              *
0869 5FF0              *
0870 5FF0              * Inputs:
0871 5FF0              *                   ctlHandle
0872 5FF0              *                   ctlPtr
0873 5FF0              *                   ctlParam = high-order word is previous value, low-order word is new value.
0874 5FF0              *
0875 5FF0              * Outputs:
0876 5FF0              *                   a-reg and x-reg are zero.
0877 5FF0              *
0878 5FF0              * External Refs:
0879 5FF0                       import DimMyRectangle          ;7-Dec-91 DAL
0880 5FF0              *
0881 5FF0              * Entry Points:
0882 5FF0              *                   none
0883 5FF0              *
0884 5FF0                       longa on                       ; mode
0885 5FF0                       longi on
0886 5FF0              *
0887 5FF0              ****************************************************************
0888 5FF0                       WITH PopUpCtlRecord 
0889 5FF0
0890 5FF0 A0 10 00              ldy   #ctlFlag                 ; check if the invisible flag is set
0891 5FF3 B7 05                 lda   [<ctlPtr],y
0892 5FF5 89 80 00              bit   #$0080                   ; if high bit of flag is set then its invisible
0893 5FF8 D0 33                 bne   doNothing
0894 5FFA
0895 5FFA 20 C0 68              jsr   SetNewMenuBar
0896 5FFD 20 29 65              jsr   SetupColorTable
0897 6000
0898 6000 A2 FF FF              ldx   #$FFFF
0899 6003 20 80 65              jsr   DrawResult
0900 6006
0901 6006              *** Skankified 7-Dec-91 DAL -- If control is dimmed, draw new value as dimmed, too.
0902 6006 0B                    phd   
0903 6007 48                    pha   
0904 6008 48                    pha                            ;space for GetWAP
0905 6009 F4 00 00              pea   0                        ;system tool
0906 600C F4 10 00              pea   $10                      ;control manager
0907 600F A2 01 0C 22           _GetWAP                        ;get Control Manager direct page
0908 6016 3B                    tsc   
0909 6017 5B                    tcd   
0910 6018 A0 4E 00              ldy   #$004E                   ;offset to Active flag
0911 601B B7 01                 lda   [1],y                    ;grab value from Control Manager workspace
0912 601D FA                    plx   
0913 601E FA                    plx   
0914 601F 2B                    pld   
0915 6020 AA                    tax   
0916 6021 10 03                 bpl   @noDim
0917 6023 20 B7 62              jsr   DimMyRectangle
0918 6026              @noDim    
0919 6026              *** end 7-Dec-91
0920 6026
0921 6026 A2 0F 39 22           _SetMenuBar 
0922 602D
0923 602D 60           doNothing rts   
0924 602E
0925 602E                       ENDP 
0926 602E
0927 602E
0928 602E                       title 'PopUp DefProc -- Do_Track' 
0929 602E              ****************************************************************
0930 602E              *
0931 602E              do_track PROC 
0932 602E              *
0933 602E              * This is the routine that is called when the mouse goes down
0934 602E              * in the control.
0935 602E              *
0936 602E              * The control manager calls this routine because, the
0937 602E              * test routine returned a part code of $80.
0938 602E              *
0939 602E              *
0940 602E              * Inputs:
0941 602E              *                   none
0942 602E              *
0943 602E              * Outputs:
0944 602E              *                   none
0945 602E              *
0946 602E              * External Refs:
0947 602E              *                   none
0948 602E              *
0949 602E              * Entry Points:
0950 602E              *                   none
0951 602E              *
0952 602E                       longa on                       ; mode
0953 602E                       longi on
0954 602E              *
0955 602E              ****************************************************************
0956 602E                       WITH PopUpCtlRecord 
0957 602E
0958 602E              CurrentSelection equ   word7
0959 602E
0960 602E A5 29                 lda   <ctlParam
0961 6030 D0 05                 bne   @notZero
0962 6032
0963 6032 A9 00 00              lda   #0
0964 6035 AA                    tax   
0965 6036 60                    rts   
0966 6037
0967 6037 20 C0 68     @notZero jsr   setNewMenuBar            ; set menu bar to that of the control, leaving original
0968 603A                                                      ; menubar still on the stack to be restored when we exit
0969 603A 48                    pha                            ; get current port and leave on stack to be restored
0970 603B 48                    pha                            ; later
0971 603C A2 04 1C 22           _GetPort 
0972 6043
0973 6043 A0 10 00              ldy   #ctlFlag
0974 6046 B7 05                 lda   [<ctlPtr],y
0975 6048 29 10 00              and   #FDontDrawTitle
0976 604B D0 1A                 bne   NoTitle
0977 604D B7 05                 lda   [<ctlPtr],y
0978 604F 29 20 00              and   #FDontHiliteTitle
0979 6052 D0 13                 bne   NoTitle
0980 6054
0981 6054 20 0F 65              jsr   derefmenuhand            ; dereference menu's handle and put pointer in <temp
0982 6057
0983 6057 F4 FF FF              PushWord #True                 ; hilite the control's title
0984 605A A0 00 00              ldy   #oMenuID
0985 605D B7 01                 lda   [<temp],y
0986 605F 48                    pha   
0987 6060 A2 0F 2C 22           _HiliteMenu 
0988 6067
0989 6067 A0 30 00     NoTitle  ldy   #PopUpRect               ; convert the upper left corner of the rect to global
0990 606A 20 DB 68              jsr   MoveRect
0991 606D 20 FD 68              jsr   PushPtrToRect
0992 6070 A2 04 84 22           _LocalToGlobal 
0993 6077
0994 6077              *** 9-Mar-91 DAL -- shift the rest of the rectangle to global coordinates
0995 6077 F4 00 00              pea   0
0996 607A 7B                    tdc   
0997 607B 69 0D 00              adc   #rect+4
0998 607E 48                    pha   
0999 607F A2 04 84 22           _LocalToGlobal 
1000 6086              *** end of 9-Mar-91 DAL
1001 6086
1002 6086 A0 10 00              ldy   #ctlFlag                 ; find out what port we should set to
1003 6089 B7 05                 lda   [<ctlPtr],y
1004 608B 29 04 00              and   #FInWindowOnly
1005 608E D0 10                 bne   SamePort
1006 6090
1007 6090 48                    pha                            ; use menu mgr's port so we can draw some long menus
1008 6091 48                    pha   
1009 6092 A2 0F 1B 22           _GetMenuMgrPort 
1010 6099 A2 04 1B 22           _SetPort 
1011 60A0
1012 60A0 48           SamePort pha                            ; space for result
1013 60A1
1014 60A1 A0 12 00              ldy   #ctlValue
1015 60A4 B7 05                 lda   [<ctlPtr],y              ; current selection
1016 60A6 48                    pha   
1017 60A7
1018 60A7 A5 0B                 lda   <rect+x1                 ; upper left corner of where to draw current selection
1019 60A9              ***
1020 60A9 3A                    dec   a                        ;added 21-Jan-91 DAL to make it line up perfectly
1021 60AA 3A                    dec   a
1022 60AB              ***
1023 60AB 48                    pha   
1024 60AC A5 09                 lda   <rect+y1
1025 60AE 48                    pha   
1026 60AF
1027 60AF A0 10 00              ldy   #ctlFlag                 ; popup flag, what type to draw (with or w/o white space)
1028 60B2 B7 05                 lda   [<ctlPtr],y
1029 60B4 29 40 00              and   #FType2PopUp
1030 60B7 48                    pha   
1031 60B8
1032 60B8              *** 9-Mar-91 DAL: call CalcMenuSize again to allow for the arrow icon!
1033 60B8 A0 3C 00              ldy   #PopUpCtlRecord.ctlMoreFlags
1034 60BB B7 05                 lda   [<ctlPtr],y
1035 60BD 29 80 00              and   #fDrawArrowIcon
1036 60C0 F0 23                 beq   @noAdj
1037 60C2
1038 60C2 20 0F 65              jsr   derefMenuHand            ;added 15-Mar-91 DAL
1039 60C5
1040 60C5 38                    sec                            ;make the popped-up menu at least as wide as the control rect
1041 60C6 A5 0F                 lda   <rect+x2
1042 60C8 E5 0B                 sbc   <rect+x1
1043 60CA 1A                    inc   a
1044 60CB 1A                    inc   a                        ;make it a bit wider, for the shadow decoration on the right
1045 60CC AA                    tax   
1046 60CD A0 02 00              ldy   #oMenuWidth
1047 60D0 D7 01                 cmp   [<temp],y                ;current menu width
1048 60D2 90 11                 bcc   @alreadyWide
1049 60D4
1050 60D4 DA                    phx                            ; new width
1051 60D5 F4 00 00              pea   0                        ; new heighth, 0 for automatic calculation
1052 60D8              ***	ldy	#oMenuID	; id of menu record (ZERO)
1053 60D8 20 0F 65              jsr   derefmenuhand            ; --> temp
1054 60DB A7 01                 lda   [<temp]
1055 60DD 48                    pha   
1056 60DE A2 0F 1C 22           _CalcMenuSize 
1057 60E5              @alreadyWide  
1058 60E5              @noAdj    
1059 60E5              *** end of 9-Mar-91 DAL
1060 60E5
1061 60E5 A0 2A 00              ldy   #MenuRef+2               ; handle to the menu record
1062 60E8 B7 05                 lda   [<ctlPtr],y
1063 60EA 48                    pha   
1064 60EB 88                    dey   
1065 60EC 88                    dey   
1066 60ED B7 05                 lda   [<ctlPtr],y
1067 60EF 48                    pha   
1068 60F0
1069 60F0 A2 0F 3C 22           _PopUpMenuSelect               ; make call to PopUpMenuSelect
1070 60F7
1071 60F7 68                    pla   
1072 60F8 85 1D                 sta   <currentSelection
1073 60FA
1074 60FA A2 04 1B 22           _SetPort                       ; restore original port
1075 6101
1076 6101 A5 1D                 lda   <currentSelection
1077 6103 F0 13                 beq   NoSelection
1078 6105
1079 6105              ;;;This code works, but it's probably not a good feature.  Applications have no
1080 6105              ;;;other way to determine what item was selected, if they want to provide menu
1081 6105              ;;;item help for dimmed items in pop-up menu controls.
1082 6105              ;*** added 7-Dec-91 DAL -- don't allow a dimmed item to become the current value
1083 6105              ;	pha		;space for result
1084 6105              ;	pei	<currentSelection
1085 6105              ;	_GetMItemFlag
1086 6105              ;	pla
1087 6105              ;	and	#$0080
1088 6105              ;	bne	NoSelection
1089 6105              ;	lda	<currentSelection
1090 6105              ;*** end 7-Dec-91
1091 6105 A0 12 00              ldy   #ctlValue
1092 6108 97 05                 sta   [<ctlPtr],y
1093 610A
1094 610A 20 29 65              jsr   SetupColorTable
1095 610D
1096 610D              ***	jsr	ReCalcPopUpRect	   ;incomplete routine from Harry (27-Sep-90 DAL)
1097 610D
1098 610D D4 1D                 pei   <currentSelection        ; save it because DrawResult trashes this value
1099 610F A2 FF FF              ldx   #$FFFF                   ; flag for DrawResult to setup some additional things
1100 6112 20 80 65              jsr   DrawResult
1101 6115 68                    pla   
1102 6116 85 1D                 sta   <currentSelection
1103 6118
1104 6118 A0 10 00     NoSelection ldy   #ctlFlag
1105 611B B7 05                 lda   [<ctlPtr],y
1106 611D 29 10 00              and   #FDontDrawTitle
1107 6120 D0 1A                 bne   bye
1108 6122 B7 05                 lda   [<ctlPtr],y
1109 6124 29 20 00              and   #FDontHiliteTitle
1110 6127 D0 13                 bne   bye
1111 6129
1112 6129 20 0F 65              jsr   derefmenuhand            ; we need to keep derefing this guy because we can't lock
1113 612C                                                      ; down the handle because most menu mgr calls upon exit
1114 612C                                                      ; unlock this handle
1115 612C F4 00 00              PushWord #False 
1116 612F A0 00 00              ldy   #oMenuId
1117 6132 B7 01                 lda   [<temp],y
1118 6134 48                    pha   
1119 6135 A2 0F 2C 22           _HiliteMenu 
1120 613C
1121 613C A2 0F 39 22  bye      _SetMenuBar 
1122 6143
1123 6143                       ENDWITH 
1124 6143
1125 6143 A5 1D                 lda   <currentSelection
1126 6145 F0 05                 beq   noHit
1127 6147 A2 A0 00              ldx   #$A0                     ; return part code for the pop-up
1128 614A 80 03                 bra   out
1129 614C
1130 614C A2 00 00     noHit    ldx   #0
1131 614F
1132 614F A9 FF FF     out      lda   #True                    ; tell control manage that we handled the drag.
1133 6152
1134 6152 60                    rts   
1135 6153
1136 6153
1137 6153                       ENDP 
1138 6153
1139 6153
1140 6153                       title 'PopUp DefProc -- Do_Move' 
1141 6153              ****************************************************************
1142 6153              *
1143 6153              do_Move  PROC Export 
1144 6153              *
1145 6153              * Updates the pop-up box's rect to the appropriate values. The ctlRect
1146 6153              * has already been changed by the control manager.
1147 6153              *
1148 6153              * Inputs:
1149 6153              *                   none
1150 6153              *
1151 6153              * Outputs:
1152 6153              *                   none
1153 6153              *
1154 6153              * External Refs:
1155 6153              *                   none
1156 6153              *
1157 6153              * Entry Points:
1158 6153              *                   none
1159 6153              *
1160 6153                       longa on                       ; mode
1161 6153                       longi on
1162 6153              *
1163 6153              ****************************************************************
1164 6153
1165 6153 A0 30 00              ldy   #PopUpCtlRecord.PopUpRect
1166 6156 20 09 69              jsr   PushPtrToRect2
1167 6159
1168 6159 D4 2B                 pei   <ctlParam+2
1169 615B D4 29                 pei   <ctlParam
1170 615D A2 04 4B 22           _OffSetRect 
1171 6164
1172 6164 A9 00 00              lda   #0
1173 6167 AA                    tax   
1174 6168
1175 6168 60                    rts   
1176 6169
1177 6169                       ENDP 
1178 6169
1179 6169
1180 6169                       title 'PopUp DefProc -- Do_Key' 
1181 6169              ****************************************************************
1182 6169              *
1183 6169              do_key   PROC Export 
1184 6169              *
1185 6169              * Handle a key or menu event.
1186 6169              *
1187 6169              * The event.what will be an Event Manager event (typically
1188 6169              * nullEvt, keyDownEvt, autoKeyEvt) or the special code
1189 6169              * wInSpecial for a menu item (ID in taskData).
1190 6169              *
1191 6169              * ctlParam is the event record.
1192 6169              *
1193 6169              * Inputs:
1194 6169              *                   none
1195 6169              *
1196 6169              * Outputs:
1197 6169              *                   none
1198 6169              *
1199 6169              * External Refs:
1200 6169              *                   none
1201 6169              *
1202 6169              * Entry Points:
1203 6169              *                   none
1204 6169              *
1205 6169                       longa on                       ; mode
1206 6169                       longi on
1207 6169              *
1208 6169              * 12 Apr 89         Steven Glass
1209 6169              *
1210 6169              * Check the control record for inactive control and invisible
1211 6169              * control.  If either is true, reject the event.
1212 6169              *
1213 6169              ****************************************************************
1214 6169
1215 6169              ; Added 12 Apr 89 SEG
1216 6169 A0 10 00              ldy   #NewCtlRecord.ctlFlag    ;Look at the flag and hilite bytes
1217 616C B7 05                 lda   [<ctlPtr],y
1218 616E AA                    tax                            ;(save a momment)
1219 616F 29 00 FF              and   #$FF00                   ;If hilite is FF, we are inactive and should
1220 6172 C9 00 FF              cmp   #$FF00                   ;ignore the event.
1221 6175 F0 75                 beq   DontWantIt
1222 6177 8A                    txa                            ;Now, check the invis bit
1223 6178 29 80 00              and   #$0080                   ;If invis, we don't want it either.
1224 617B D0 6F                 bne   DontWantIt
1225 617D              ; End Addition
1226 617D
1227 617D              *** added 17-Nov-92 DAL -- Only send keyDown and autoKey events to MenuKey
1228 617D A7 29                 lda   [<ctlParam]
1229 617F C9 03 00              cmp   #keyDownEvt
1230 6182 F0 05                 beq   @isKey
1231 6184 C9 05 00              cmp   #autoKeyEvt
1232 6187 D0 63                 bne   DontWantIt
1233 6189              @isKey    
1234 6189              *** Preserve menu bar around the MenuKey call
1235 6189 48                    pha   
1236 618A 48                    pha   
1237 618B A2 0F 0A 22           _GetMenuBar 
1238 6192              *** end 17-Nov-92 DAL
1239 6192 D4 2B                 pei   <ctlParam+2              ;pointer to task record containing char to check
1240 6194 D4 29                 pei   <ctlParam
1241 6196 D4 27                 pei   <theCtlHandle+2
1242 6198 D4 25                 pei   <theCtlHandle
1243 619A A2 0F 09 22           _MenuKey 
1244 61A1              *** added 17-Nov-92 DAL -- restore menu bar
1245 61A1 A2 0F 39 22           _SetMenuBar 
1246 61A8              *** end 17-Nov-92
1247 61A8
1248 61A8 A0 10 00              ldy   #owmTaskData
1249 61AB B7 29                 lda   [<ctlParam],y
1250 61AD D0 03                 bne   @1
1251 61AF 82 3A 00              brl   DontWantIt
1252 61B2
1253 61B2 A0 12 00     @1       ldy   #PopUpCtlRecord.ctlvalue
1254 61B5 97 05                 sta   [<ctlPtr],y
1255 61B7
1256 61B7 20 C0 68              jsr   SetNewMenuBar
1257 61BA 20 29 65              jsr   SetupColorTable
1258 61BD
1259 61BD A2 FF FF              ldx   #$FFFF
1260 61C0 20 80 65              jsr   DrawResult
1261 61C3
1262 61C3 A0 10 00              ldy   #PopUpCtlRecord.ctlFlag
1263 61C6 B7 05                 lda   [<ctlPtr],y              ; check if there is a title or not
1264 61C8 29 10 00              and   #FDontDrawTitle
1265 61CB D0 13                 bne   noTitle
1266 61CD
1267 61CD 20 0F 65              jsr   derefmenuhand
1268 61D0
1269 61D0 F4 00 00              pea   0                        ;unhilite the popup's title highlighted by MenuKey
1270 61D3 A0 00 00              ldy   #oMenuID
1271 61D6 B7 01                 lda   [<temp],y
1272 61D8 48                    pha   
1273 61D9 A2 0F 2C 22           _HiliteMenu 
1274 61E0
1275 61E0 A2 0F 39 22  noTitle  _SetMenuBar 
1276 61E7
1277 61E7 A9 FF FF              lda   #$FFFF                   ;Return true for having handled event
1278 61EA AA                    tax   
1279 61EB 60                    rts   
1280 61EC
1281 61EC A9 00 00     DontWantIt lda   #0                     ;Return False, don't want event.
1282 61EF AA                    tax   
1283 61F0
1284 61F0 60                    rts   
1285 61F1
1286 61F1                       ENDP 
1287 61F1
1288 61F1
1289 61F1                       title 'PopUp DefProc -- Do_StateChange' 
1290 61F1              ****************************************************************
1291 61F1              *
1292 61F1              do_stateChange PROC Export 
1293 61F1              *
1294 61F1              * This message is sent when the state of the window that the control is
1295 61F1              * in has changed.
1296 61F1              *
1297 61F1              * Inputs:
1298 61F1              *                   none
1299 61F1              *
1300 61F1              * Outputs:
1301 61F1              *                   none
1302 61F1              *
1303 61F1              * External Refs:
1304 61F1              *                   none
1305 61F1              *
1306 61F1              * Entry Points:
1307 61F1              *                   none
1308 61F1              *
1309 61F1                       longa on                       ; mode
1310 61F1                       longi on
1311 61F1              *
1312 61F1              ****************************************************************
1313 61F1
1314 61F1 A0 08 00              ldy   #PopUpCtlRecord.ctlRect
1315 61F4 20 09 69              jsr   PushPtrToRect2
1316 61F7 A2 0E 3A 22           _InvalRect 
1317 61FE
1318 61FE AA                    tax   
1319 61FF
1320 61FF 60                    rts   
1321 6200
1322 6200                       ENDP 
1323 6200
1324 6200              ****************************************************************
1325 6200              *
1326 6200              GetPopUpDefProc PROC Export 
1327 6200              *
1328 6200              * Returns the address of the PopUp control def-proc.
1329 6200              *
1330 6200              *
1331 6200              * Inputs:
1332 6200              *                   space for pointer
1333 6200              *
1334 6200              * Outputs:
1335 6200              *                   Pointer to DefProc
1336 6200              *
1337 6200              * External Refs:
1338 6200                       import PopUpProc 
1339 6200              *
1340 6200              * Entry Points:
1341 6200              *                   none
1342 6200              *
1343 6200                       longa on                       ; mode
1344 6200                       longi on
1345 6200              *
1346 6200              ****************************************************************
1347 6200                       DefineStack 
1348 6200              RTL1     block 3 
1349 6200              RTL2     block 3 
1350 6200              ThePointer LONG 
1351 6200
1352 6200 A9 94 5F              lda   #PopUpProc
1353 6203 83 07                 sta   ThePointer,s
1354 6205 A9 02 00              lda   #^PopUpProc
1355 6208 83 09                 sta   ThePointer+2,s
1356 620A
1357 620A A9 00 00              lda   #0
1358 620D 18                    clc   
1359 620E 6B                    rtl   
1360 620F
1361 620F                       ENDP 
1362 620F
1363 620F              ********************************************************************************
1364 620F              *
1365 620F              *                   DerefMenuHand
1366 620F              *
1367 620F              * Dereference the menu handle in PopUpCtlRecord.MenuRef and put ptr in our direct
1368 620F              * page space Temp.
1369 620F              *
1370 620F              ********************************************************************************
1371 620F              derefMenuHand PROC 
1372 620F
1373 620F A0 28 00              ldy   #PopUpCtlRecord.MenuRef
1374 6212 B7 05                 lda   [<ctlPtr],y
1375 6214 85 01                 sta   <temp
1376 6216 C8                    iny   
1377 6217 C8                    iny   
1378 6218 B7 05                 lda   [<ctlPtr],y
1379 621A 85 03                 sta   <temp+2
1380 621C
1381 621C A7 01                 lda   [<temp]
1382 621E AA                    tax   
1383 621F A0 02 00              ldy   #2
1384 6222 B7 01                 lda   [<temp],y
1385 6224 85 03                 sta   <temp+2
1386 6226 86 01                 stx   <temp
1387 6228
1388 6228 60                    rts   
1389 6229
1390 6229                       ENDP 
1391 6229
1392 6229              ********************************************************************************
1393 6229              *
1394 6229              *                   SetupColorTable
1395 6229              *
1396 6229              *                   This routine puts the pointer to the pop-up control's
1397 6229              *                   color table into our direct page space <word1. If the
1398 6229              *                   ctlColor field of the record is zero then we use the
1399 6229              *                   default color table defined in PopUpData.
1400 6229              *
1401 6229              *  IN: <ctlPtr = ptr to pop-up's control record
1402 6229              * OUT: <word1 = ptr to pop-up's color table (if ctlColor field is zero
1403 6229              *               then we use the default color table)
1404 6229              *
1405 6229              ********************************************************************************
1406 6229              SetupColorTable PROC 
1407 6229
1408 6229 A0 26 00              ldy   #PopUpCtlRecord.ctlColor+2 ; get pop-up's color table
1409 622C B7 05                 lda   [<ctlPtr],y              ; if this field is zero then it means we use
1410 622E 88                    dey                            ; the default color table
1411 622F 88                    dey   
1412 6230 17 05                 ora   [<ctlPtr],y
1413 6232 F0 41                 beq   @DefaultColor            ; use default color table
1414 6234
1415 6234 A0 24 00              ldy   #PopUpCtlRecord.ctlColor
1416 6237 B7 05                 lda   [<ctlPtr],y
1417 6239 85 11                 sta   <word1
1418 623B C8                    iny   
1419 623C C8                    iny   
1420 623D B7 05                 lda   [<ctlPtr],y
1421 623F 85 13                 sta   <word1+2
1422 6241
1423 6241 A0 3C 00              ldy   #PopUpCtlRecord.ctlmoreflags
1424 6244 B7 05                 lda   [<ctlPtr],y
1425 6246 29 18 00              and   #$0018                   ; bits 3 and 4 tell us what the color table is made of
1426 6249 F0 34                 beq   @Done
1427 624B
1428 624B 89 08 00              bit   #$0008                   ; Is color table a handle?
1429 624E D0 18                 bne   @ColorTableIsHandle
1430 6250
1431 6250              @ColorTableIsResource  
1432 6250 48                    pha   
1433 6251 48                    pha   
1434 6252 F4 0D 80              PushWord #rCtlColorTbl         ;was rCtlColorTable 17-Sep-90 DAL
1435 6255 A5 13                 lda   <word1+2
1436 6257 48                    pha   
1437 6258 A5 11                 lda   <word1
1438 625A 48                    pha   
1439 625B A2 10 32 22           _CMLoadResource 
1440 6262 68                    pla   
1441 6263 85 11                 sta   <word1
1442 6265 68                    pla   
1443 6266 85 13                 sta   <word1+2
1444 6268
1445 6268              @ColorTableIsHandle  
1446 6268 A0 02 00              ldy   #2
1447 626B B7 11                 lda   [<word1],y
1448 626D AA                    tax   
1449 626E A7 11                 lda   [<word1]
1450 6270 85 11                 sta   <word1
1451 6272 86 13                 stx   <word1+2
1452 6274
1453 6274 60                    rts   
1454 6275
1455 6275 A9 28 69     @DefaultColor lda   #DefColorTable
1456 6278 85 11                 sta   <word1
1457 627A A9 02 00              lda   #^DefColorTable
1458 627D 85 13                 sta   <word1+2
1459 627F
1460 627F 60           @Done    rts   
1461 6280
1462 6280                       ENDP 
1463 6280
1464 6280              ********************************************************************************
1465 6280              *
1466 6280              *                   DrawResult
1467 6280              *
1468 6280              *                   This routine draws the currently selected menu item in
1469 6280              *                   the pop-up rect. It first checks whether the FDontDrawResult
1470 6280              *                   bit is set before doing anything. If the item ID in ctlValue
1471 6280              *                   is invalid (carry set coming back from GetMItem) then we clear
1472 6280              *                   whatever is currently in the pop-up rect and set ctlValue to zero.
1473 6280              *
1474 6280              *  IN: <word1 : contains ptr to pop-up's color table (call SetupColorTable)
1475 6280              *      pop-up control's record is the current menu bar (call SetNewMenuBar)
1476 6280              *      x-reg : $0000 = don't need to setup popup rect in <RECT (already done by DrawPopupBox)
1477 6280              *              $FFFF = we need to setup <RECT still
1478 6280              *
1479 6280              ********************************************************************************
1480 6280              DrawResult PROC 
1481 6280                       import CheckForIcon 
1482 6280
1483 6280              ItemNameHdl equ   word3
1484 6280              ItemNamePtr equ   word5
1485 6280              mode     equ   word7
1486 6280
1487 6280 A0 10 00              ldy   #PopUpCtlRecord.ctlFlag  ; first check if result should be drawn
1488 6283 B7 05                 lda   [<ctlPtr],y
1489 6285 29 08 00              and   #FDontDrawResult
1490 6288 F0 03                 beq   okToDraw
1491 628A 82 29 02              brl   out
1492 628D
1493 628D 8A           okToDraw txa                            ; flag that tells us whether we're just drawing result
1494 628E 10 03                 bpl   SkipThisSetup
1495 6290
1496 6290 20 5A 68              jsr   ClearResult
1497 6293
1498 6293 48           SkipThisSetup pha                       ; space for result
1499 6294 48                    pha   
1500 6295 A0 12 00              ldy   #PopUpCtlRecord.ctlValue  ; get pointer to currently selected item in pop-up menu
1501 6298 B7 05                 lda   [<ctlPtr],y
1502 629A F0 0A                 beq   @Invalid                 ; if ctlValue is zero, its means nothing currently selected
1503 629C 48                    pha                            ; must special case zero because zero item id to GetMItem
1504 629D A2 0F 25 22           _GetMItem                      ; means get first item in menu!!!
1505 62A4 90 05                 bcc   @skipit                  ; item found
1506 62A6 68           @Invalid pla                            ; clean up stack first
1507 62A7 68                    pla   
1508 62A8 82 0C 02              brl   Errout
1509 62AB
1510 62AB 68           @skipit  pla   
1511 62AC 85 19                 sta   <itemNamePtr
1512 62AE 68                    pla   
1513 62AF 85 1B                 sta   <itemNamePtr+2
1514 62B1
1515 62B1 64 15                 stz   <ItemNameHdl
1516 62B3 64 17                 stz   <ItemNameHdl+2
1517 62B5
1518 62B5 F4 00 00              pea   0
1519 62B8 A0 12 00              ldy   #PopUpCtlRecord.ctlValue
1520 62BB B7 05                 lda   [<ctlPtr],y
1521 62BD 48                    pha   
1522 62BE A2 0F 27 22           _GetMItemFlag 
1523 62C5 68                    pla   
1524 62C6 29 00 C0              and   #$C000                   ; mask off high two bits of item flag to get ref
1525 62C9 F0 37                 beq   pointer                  ; 00 = ptr
1526 62CB 10 16                 bpl   handle                   ; 01 = handle
1527 62CD
1528 62CD 48                    pha                            ; 10 = resource
1529 62CE 48                    pha   
1530 62CF F4 06 80              pea   $8006                    ; string resource
1531 62D2 D4 1B                 pei   <ItemNamePtr+2
1532 62D4 D4 19                 pei   <ItemNamePtr
1533 62D6 A2 10 32 22           _CMLoadResource 
1534 62DD 68                    pla   
1535 62DE 85 19                 sta   <ItemNamePtr
1536 62E0 68                    pla   
1537 62E1 85 1B                 sta   <ItemNamePtr+2
1538 62E3
1539 62E3 A5 19        handle   lda   <ItemNamePtr
1540 62E5 85 15                 sta   <ItemNameHdl
1541 62E7 A5 1B                 lda   <ItemNamePtr+2
1542 62E9 85 17                 sta   <ItemNameHdl+2
1543 62EB A0 04 00              ldy   #4                       ; first lock down handle
1544 62EE B7 15                 lda   [<ItemNameHdl],y
1545 62F0 09 00 80              ora   #$8000
1546 62F3 97 15                 sta   [<ItemNameHdl],y
1547 62F5              ;;;	ldy	#2	; deref the handle
1548 62F5 88                    dey   
1549 62F6 88                    dey   
1550 62F7 B7 15                 lda   [<ItemNameHdl],y
1551 62F9 85 1B                 sta   <ItemNamePtr+2
1552 62FB A7 15                 lda   [<ItemNameHdl]
1553 62FD 85 19                 sta   <ItemNamePtr
1554 62FF
1555 62FF 20 29 65              jsr   SetupColorTable          ; reset ptr to color table just in case memory moved
1556 6302                                                      ; from above load resource
1557 6302              pointer   
1558 6302 20 FD 68              jsr   PushPtrToRect            ; inset the rect to get it ready for drawing the result
1559 6305 F4 02 00              pea   2
1560 6308 F4 01 00              pea   1
1561 630B A2 04 4C 22           _InsetRect 
1562 6312
1563 6312 48                    pha                            ; get foreground color and save on the stack
1564 6313 A2 04 A1 22           _GetForeColor 
1565 631A
1566 631A 48                    pha   
1567 631B A2 04 9B 22           _GetTextFace                   ; save original text face
1568 6322
1569 6322 48                    pha   
1570 6323 A2 04 9D 22           _GetTextMode                   ; save original text mode
1571 632A
1572 632A F4 04 00              pea   4                        ; Transfer foreground pixels only
1573 632D A2 04 9C 22           _SetTextMode 
1574 6334
1575 6334 48                    pha                            ; clip title to the pop-up rectangle
1576 6335 48                    pha   
1577 6336 A2 04 C7 22           _GetClipHandle 
1578 633D
1579 633D 48                    pha                            ; get a new clip region
1580 633E 48                    pha   
1581 633F A2 04 67 22           _NewRgn 
1582 6346 A3 03                 lda   3,s
1583 6348 48                    pha   
1584 6349 A3 03                 lda   3,s
1585 634B 48                    pha   
1586 634C A2 04 C6 22           _SetClipHandle 
1587 6353
1588 6353 20 FD 68              jsr   PushPtrToRect
1589 6356 A2 04 26 22           _ClipRect 
1590 635D
1591 635D 20 FD 68              jsr   PushPtrToRect            ; put rect back the way it was before
1592 6360 F4 FE FF              pea   $FFFE
1593 6363 F4 FF FF              pea   $FFFF
1594 6366 A2 04 4C 22           _InsetRect 
1595 636D
1596 636D A7 11                 lda   [<word1]
1597 636F 29 0F 00              and   #$000F
1598 6372 48                    pha   
1599 6373 0A                    asl   a
1600 6374 0A                    asl   a
1601 6375 0A                    asl   a
1602 6376 0A                    asl   a
1603 6377 03 01                 ora   1,s
1604 6379 83 01                 sta   1,s
1605 637B EB                    xba   
1606 637C 03 01                 ora   1,s
1607 637E 83 01                 sta   1,s
1608 6380 A2 04 A0 22           _SetForeColor                  ; set the color of the text
1609 6387
1610 6387 48                    pha                            ; space for result
1611 6388 A0 12 00              ldy   #PopUpCtlRecord.ctlValue
1612 638B B7 05                 lda   [<ctlPtr],y
1613 638D 48                    pha   
1614 638E A2 0F 36 22           _GetMItemStyle 
1615 6395 A2 04 9A 22           _SetTextFace 
1616 639C
1617 639C 48                    pha                            ; leading
1618 639D 48                    pha                            ; widmax
1619 639E 48                    pha                            ; descent
1620 639F 48                    pha                            ; ascent
1621 63A0 3B                    tsc   
1622 63A1 1A                    inc   a
1623 63A2 F4 00 00              pea   0
1624 63A5 48                    pha   
1625 63A6 A2 04 96 22           _GetFontInfo 
1626 63AD 7A                    ply                            ; get ascent off stack
1627 63AE 68                    pla                            ; get descent off stack
1628 63AF 7A                    ply                            ; get widmax off stack
1629 63B0 7A                    ply                            ; get leading off stack
1630 63B1
1631 63B1 18                    clc   
1632 63B2 69 02 00              adc   #2
1633 63B5 48                    pha   
1634 63B6
1635 63B6 A0 10 00              ldy   #PopUpCtlRecord.ctlFlag
1636 63B9 B7 05                 lda   [<ctlPtr],y
1637 63BB 29 01 00              and   #FRightJustifyResult
1638 63BE F0 16                 beq   LeftJustifyResult
1639 63C0
1640 63C0 48                    pha                            ; space for result
1641 63C1 D4 1B                 pei   <ItemNamePtr+2
1642 63C3 D4 19                 pei   <ItemNamePtr
1643 63C5 A2 04 A9 22           _StringWidth 
1644 63CC A5 0F                 lda   <Rect+x2
1645 63CE 38                    sec   
1646 63CF E3 01                 sbc   1,s
1647 63D1 E9 03 00              sbc   #3
1648 63D4 80 13                 bra   storeLeft
1649 63D6              LeftJustifyResult  
1650 63D6 48                    pha                            ; calculate amount of space to indent result
1651 63D7 F4 57 00              pea   $57
1652 63DA A2 04 A8 22           _CharWidth 
1653 63E1 A3 01                 lda   1,s
1654 63E3 6A                    ror   a
1655 63E4 18                    clc   
1656 63E5 63 01                 adc   1,s
1657 63E7 65 0B                 adc   <Rect+x1
1658 63E9 AA           storeLeft tax   
1659 63EA 68                    pla   
1660 63EB
1661 63EB A5 0D                 lda   <Rect+y2
1662 63ED 38                    sec   
1663 63EE E3 01                 sbc   1,s
1664 63F0 7A                    ply   
1665 63F1 DA                    phx   
1666 63F2 48                    pha   
1667 63F3
1668 63F3 20 2E 69              jsr   CheckForIcon             ; check to see if menu item has an icon associated with it
1669 63F6                                                      ; and if we need to draw it.
1670 63F6
1671 63F6 A3 03                 lda   3,s                      ;X coord
1672 63F8 8F C0 67 02           sta   >theXpos
1673 63FC A2 04 3A 22           _MoveTo 
1674 6403
1675 6403              ;;	lda	<ItemNamePtr+2
1676 6403              ;;	pha
1677 6403              ;;	lda	<ItemNamePtr
1678 6403              ;;	pha
1679 6403              ;;	_DrawString
1680 6403              *** 16-Mar-92 DAL -- use DrawStringWidth to draw result
1681 6403 F4 00 40              pea   $4000                    ;center-trunc, pstring ptr
1682 6406 D4 1B                 pei   <ItemNamePtr+2
1683 6408 D4 19                 pei   <ItemNamePtr             ;string pointer
1684 640A 38                    sec   
1685 640B A5 0F                 lda   <Rect+x2
1686 640D EF C0 67 02           sbc   >theXpos
1687 6411 48                    pha   
1688 6412
1689 6412 A0 3C 00              ldy   #PopUpCtlRecord.ctlMoreFlags
1690 6415 B7 05                 lda   [<ctlPtr],y
1691 6417 29 80 00              and   #fDrawArrowIcon
1692 641A F0 07                 beq   @drawResult
1693 641C
1694 641C 20 C2 67              jsr   GetNegIconWidth
1695 641F 63 01                 adc   1,s
1696 6421 83 01                 sta   1,s
1697 6423
1698 6423              @drawResult  
1699 6423 A2 12 15              ldx   #$1512
1700 6426 22 00 00 E1           jsl   $e10000
1701 642A              ;	_DrawStringWidth
1702 642A              *** end 16-Mar-92
1703 642A
1704 642A
1705 642A              *** Added 21-Jan-91 DAL
1706 642A              *** If fDrawArrowIcon is set, draw a down-pointing arrow after the item
1707 642A A0 3C 00              ldy   #PopUpCtlRecord.ctlMoreFlags
1708 642D B7 05                 lda   [<ctlPtr],y
1709 642F 29 80 00              and   #fDrawArrowIcon
1710 6432 F0 26                 beq   @noDownArrow
1711 6434
1712 6434 48                    pha   
1713 6435 48                    pha                            ;space for GetSysIcon result
1714 6436 F4 02 00              pea   2                        ;misc icons
1715 6439 F4 03 00              pea   3                        ;down arrow icon
1716 643C 48                    pha   
1717 643D 48                    pha                            ;long aux value (ignored)
1718 643E A2 12 0F 22           _GetSysIcon 
1719 6445 F4 00 00              pea   0                        ;icon mode
1720 6448 20 C2 67              jsr   GetNegIconWidth
1721 644B 65 0F                 adc   <Rect+x2                 ;right edge minus width or half-of-width
1722 644D 48                    pha   
1723 644E A5 09                 lda   <Rect+y1
1724 6450 1A                    inc   a                        ;Ought to get the font height here
1725 6451 1A                    inc   a
1726 6452 48                    pha   
1727 6453 A2 12 0B 22           _DrawIcon 
1728 645A              @noDownArrow  
1729 645A              *** end of 21-Jan-91 DAL
1730 645A
1731 645A A5 16                 lda   <ItemNameHdl+1
1732 645C F0 35                 beq   NoHandle
1733 645E
1734 645E A0 04 00              ldy   #4                       ; unlock handle to the title
1735 6461 B7 15                 lda   [<ItemNameHdl],y
1736 6463              ;	and	#$7FFF
1737 6463 0A                    asl   a
1738 6464 4A                    lsr   a
1739 6465 97 15                 sta   [<ItemNameHdl],y
1740 6467
1741 6467 F4 00 00              pea   0
1742 646A A0 12 00              ldy   #PopUpCtlRecord.ctlValue
1743 646D B7 05                 lda   [<ctlPtr],y
1744 646F 48                    pha   
1745 6470 A2 0F 27 22           _GetMItemFlag 
1746 6477 68                    pla   
1747 6478 10 19                 bpl   NotResource              ; if zero then item string was not a resource
1748 647A
1749 647A F4 06 80              pea   $8006                    ; pstring resource
1750 647D
1751 647D 48                    pha                            ; result space for GetMItem
1752 647E 48                    pha   
1753 647F A0 12 00              ldy   #PopUpCtlRecord.ctlValue
1754 6482 B7 05                 lda   [<ctlPtr],y
1755 6484 48                    pha   
1756 6485 A2 0F 25 22           _GetMItem 
1757 648C
1758 648C A2 10 33 22           _CMReleaseResource 
1759 6493
1760 6493              NotResource  
1761 6493 A2 04 68 22  NoHandle _DisposeRgn 
1762 649A A2 04 C6 22           _SetClipHandle 
1763 64A1
1764 64A1 A2 04 9C 22           _SetTextMode                   ; restore original stuff
1765 64A8 A2 04 9A 22           _SetTextFace 
1766 64AF A2 04 A0 22           _SetForeColor                  ; restore original foreground color
1767 64B6
1768 64B6 60           out      rts   
1769 64B7
1770 64B7 A0 12 00     Errout   ldy   #PopUpCtlRecord.ctlValue
1771 64BA A9 00 00              lda   #0                       ; zero ctlValue, this tells us there is no current selection
1772 64BD 97 05                 sta   [<ctlPtr],y
1773 64BF
1774 64BF 60                    rts   
1775 64C0
1776 64C0 00 00        theXpos  DC W:0
1777 64C2
1778 64C2              *
1779 64C2              * GetNegIconWidth
1780 64C2              *
1781 64C2 A9 16 00     GetNegIconWidth lda   #22
1782 64C5 20 CD 67              jsr   HalfIf320
1783 64C8 49 FF FF              eor   #$ffff
1784 64CB 38                    sec   
1785 64CC 60                    rts   
1786 64CD
1787 64CD              *
1788 64CD              * HalfIf320 -- in 640 mode, return A unchanged, carry clear
1789 64CD              *              in 320 mode, return A cut in half, carry clear
1790 64CD              *
1791 64CD              * (The carry is always clear so we can ADC when we come back)
1792 64CD              *
1793 64CD 48           HalfIf320 pha   
1794 64CE 48                    pha   
1795 64CF A2 04 17 22           _GetMasterSCB 
1796 64D6 68                    pla   
1797 64D7 29 80 00              and   #$0080
1798 64DA D0 04                 bne   @640
1799 64DC 68                    pla   
1800 64DD 4A                    lsr   a
1801 64DE 18                    clc   
1802 64DF 60                    rts   
1803 64E0 68           @640     pla   
1804 64E1 18                    clc   
1805 64E2 60                    rts   
1806 64E3
1807 64E3                       ENDP 
1808 64E3
1809 64E3              ********************************************************************************
1810 64E3              *
1811 64E3              *                   DrawPopUpBox
1812 64E3              *
1813 64E3              *                   Draws the pop-up rect and the drop shadow.
1814 64E3              *
1815 64E3              *  IN: <word1 : contains ptr to color table for pop-up
1816 64E3              *      <word7 : contains flag to tell us what mode we're in
1817 64E3              *
1818 64E3              ********************************************************************************
1819 64E3              DrawPopUpBox PROC 
1820 64E3
1821 64E3              mode     equ   word7
1822 64E3
1823 64E3 20 5A 68              jsr   ClearResult              ; setup <RECT and fill background color of pop-up
1824 64E6
1825 64E6 A2 01 00              ldx   #1                       ; set the pen size
1826 64E9 A5 1D                 lda   <mode
1827 64EB F0 01                 beq   Not640
1828 64ED E8                    inx   
1829 64EE DA           Not640   phx                            ; width of pen
1830 64EF F4 01 00              pea   1                        ; height of pen
1831 64F2 A2 04 2C 22           _SetPenSize 
1832 64F9
1833 64F9              ***	pea	color_patt>>16	; make sure pen pattern is setup according to
1834 64F9                       entry SelfMod2High 
1835 64F9 F4 77 77     SelfMod2High pea   $7777                ; 26-Sep-90 DAL
1836 64FC A0 04 00              ldy   #4                       ; pop-up menu's color table
1837 64FF B7 11                 lda   [<word1],y
1838 6501 29 F0 00              and   #$00F0
1839 6504 0A                    asl   a
1840 6505              ***	adc	#color_patt
1841 6505                       entry SelfMod2Low 
1842 6505 69 77 77     SelfMod2Low adc   #$7777                ; 26-Sep-90 DAL
1843 6508 48                    pha   
1844 6509 A2 04 30 22           _SetPenPat 
1845 6510
1846 6510 20 FD 68              jsr   PushPtrToRect            ; now frame it
1847 6513 A2 04 53 22           _FrameRect 
1848 651A
1849 651A              ;
1850 651A              ; --- Draw the drop shadow for the pop-up rect ---------------------------------------
1851 651A              ;
1852 651A A4 0F                 ldy   <Rect+x2                 ; Pass last point
1853 651C 5A                    phy   
1854 651D A5 09                 lda   <Rect+y1
1855 651F 18                    clc   
1856 6520 69 04 00              adc   #4
1857 6523 48                    pha   
1858 6524
1859 6524 5A                    phy                            ; Pass second point
1860 6525 A6 0D                 ldx   <Rect+y2
1861 6527 DA                    phx   
1862 6528
1863 6528 A5 0B                 lda   <Rect+x1                 ; Set starting point
1864 652A 18                    clc   
1865 652B 69 05 00              adc   #5
1866 652E 48                    pha   
1867 652F DA                    phx   
1868 6530 A2 04 3A 22           _MoveTo 
1869 6537 A2 04 3C 22           _LineTo 
1870 653E
1871 653E A9 01 00              lda   #1
1872 6541 A6 1D                 ldx   <mode
1873 6543 F0 01                 beq   In320mode
1874 6545 1A                    inc   a
1875 6546 0A           In320mode asl   a
1876 6547 48                    pha   
1877 6548 F4 01 00              pea   1
1878 654B A2 04 2C 22           _SetPenSize 
1879 6552 A2 04 3C 22           _LineTo 
1880 6559
1881 6559 60                    rts   
1882 655A
1883 655A                       ENDP 
1884 655A
1885 655A              ********************************************************************************
1886 655A              *
1887 655A              *                   ClearResult
1888 655A              *
1889 655A              *                   This routine clears the item in the pop-up rect
1890 655A              *                   it also puts the popup rect in <RECT.
1891 655A              *
1892 655A              *  IN: <ctlPtr : ptr to pop-up control record
1893 655A              *      <word1 : contains ptr to pop-up control's color table
1894 655A              * OUT: <RECT contains the pop-up rect (not including right drop shadow)
1895 655A              *
1896 655A              ********************************************************************************
1897 655A              ClearResult PROC 
1898 655A
1899 655A 48                    pha   
1900 655B A2 04 17 22           _GetMasterSCB 
1901 6562 68                    pla   
1902 6563 29 80 00              and   #$0080
1903 6566 85 1D                 sta   <word7
1904 6568
1905 6568 A0 30 00              ldy   #PopUpCtlRecord.PopUpRect
1906 656B 20 DB 68              jsr   MoveRect
1907 656E
1908 656E A4 0F                 ldy   <Rect+x2
1909 6570 88                    dey   
1910 6571 88                    dey   
1911 6572 A5 1D                 lda   <word7
1912 6574 F0 02                 beq   Its320
1913 6576 88                    dey   
1914 6577 88                    dey   
1915 6578 84 0F        Its320   sty   <Rect+x2
1916 657A
1917 657A C6 0D                 dec   <Rect+y2                 ; adjust for bottom drop shadow
1918 657C
1919 657C 20 FD 68              jsr   PushPtrToRect
1920 657F A2 01 00              ldx   #1
1921 6582 A5 1D                 lda   <word7
1922 6584 F0 01                 beq   pushit1
1923 6586 E8                    inx   
1924 6587 DA           pushit1  phx   
1925 6588 F4 01 00              pea   1
1926 658B A2 04 4C 22           _InsetRect 
1927 6592
1928 6592 20 FD 68              jsr   PushPtrToRect            ; no valid current selection
1929 6595              ***	pea	color_patt>>16
1930 6595                       entry SelfMod3High 
1931 6595 F4 77 77     SelfMod3High pea   $7777                ; 26-Sep-90 DAL
1932 6598 A7 11                 lda   [<word1]
1933 659A 29 F0 00              and   #$00F0
1934 659D 0A                    asl   a
1935 659E              ***	adc	#color_patt
1936 659E                       entry SelfMod3Low 
1937 659E 69 77 77     SelfMod3Low adc   #$7777                ; 26-Sep-90 DAL
1938 65A1 48                    pha   
1939 65A2 A2 04 57 22           _FillRect 
1940 65A9
1941 65A9 20 FD 68              jsr   PushPtrToRect
1942 65AC A2 FF FF              ldx   #$FFFF
1943 65AF A5 1D                 lda   <word7
1944 65B1 F0 01                 beq   pushit2
1945 65B3 CA                    dex   
1946 65B4 DA           pushit2  phx   
1947 65B5 F4 FF FF              pea   $FFFF
1948 65B8 A2 04 4C 22           _InsetRect 
1949 65BF
1950 65BF 60                    rts   
1951 65C0
1952 65C0                       ENDP 
1953 65C0
1954 65C0              ********************************************************************************
1955 65C0              *
1956 65C0              *                   SetNewMenuBar
1957 65C0              *
1958 65C0              * Saves the handle to the old menu bar on the stack and then sets the new menu bar
1959 65C0              * to that of the control handle.
1960 65C0              *
1961 65C0              ********************************************************************************
1962 65C0              setNewMenuBar PROC 
1963 65C0
1964 65C0 68                    pla                            ; get rts off the stack
1965 65C1 85 11                 sta   <word1
1966 65C3
1967 65C3 48                    pha                            ; save original menubar on the stack
1968 65C4 48                    pha   
1969 65C5 A2 0F 0A 22           _GetMenuBar 
1970 65CC
1971 65CC              ;	lda	<theCtlHandle+2	; make the new menu bar the popup control
1972 65CC              ;	pha
1973 65CC              ;	lda	<theCtlHandle
1974 65CC              ;	pha
1975 65CC              *** opt 13-Mar-92 DAL
1976 65CC D4 27                 pei   <theCtlHandle+2          ; make the new menu bar the pop-up control
1977 65CE D4 25                 pei   <theCtlHandle
1978 65D0              ***
1979 65D0 A2 0F 39 22           _SetMenuBar 
1980 65D7
1981 65D7 A5 11                 lda   <word1
1982 65D9 48                    pha   
1983 65DA
1984 65DA 60                    rts   
1985 65DB
1986 65DB                       ENDP 
1987 65DB
1988 65DB
1989 65DB              ********************************************************************************
1990 65DB              *
1991 65DB              * MoveRect
1992 65DB              *
1993 65DB              * Moves the rectangle from the control record
1994 65DB              * to direct page.
1995 65DB              *
1996 65DB              * The source rectangle is specified by placing
1997 65DB              * its offset in the y-reg.
1998 65DB              *
1999 65DB              ********************************************************************************
2000 65DB              MoveRect PROC 
2001 65DB
2002 65DB A2 00 00              ldx   #0                       ; copy rect to d page
2003 65DE B7 05        @1       lda   [CtlPtr],y
2004 65E0 95 09                 sta   rect,x
2005 65E2 C8                    iny   
2006 65E3 C8                    iny   
2007 65E4 E8                    inx   
2008 65E5 E8                    inx   
2009 65E6 E0 08 00              cpx   #8
2010 65E9 90 F3                 bcc   @1
2011 65EB
2012 65EB 60                    rts   
2013 65EC
2014 65EC                       ENDP 
2015 65EC
2016 65EC
2017 65EC              ********************************************************************************
2018 65EC              *
2019 65EC              * MoveRectIn
2020 65EC              *
2021 65EC              * Moves the rectangle from direct page to the control record
2022 65EC              *
2023 65EC              * The destination rectangle is specified by placing
2024 65EC              * its offset in the y-reg.
2025 65EC              *
2026 65EC              ********************************************************************************
2027 65EC              MoveRectIn PROC 
2028 65EC
2029 65EC A2 00 00              ldx   #0
2030 65EF B5 09        @1       lda   Rect,x
2031 65F1 97 05                 sta   [CtlPtr],y
2032 65F3 C8                    iny   
2033 65F4 C8                    iny   
2034 65F5 E8                    inx   
2035 65F6 E8                    inx   
2036 65F7 E0 08 00              cpx   #8
2037 65FA 90 F3                 bcc   @1
2038 65FC
2039 65FC 60                    rts   
2040 65FD
2041 65FD                       ENDP 
2042 65FD
2043 65FD
2044 65FD              ********************************************************************************
2045 65FD              *
2046 65FD              * PushPtrToRect
2047 65FD              *
2048 65FD              * Pushes pointer to controls bounding rect.
2049 65FD              *
2050 65FD              ********************************************************************************
2051 65FD              PushPtrToRect PROC 
2052 65FD
2053 65FD 7A                    ply                            ; save rts
2054 65FE F4 00 00              pea   0000
2055 6601 7B                    tdc   
2056 6602 18                    clc   
2057 6603 69 09 00              adc   #Rect                    ; get address of rect on stack
2058 6606 48                    pha   
2059 6607
2060 6607 5A                    phy                            ; restore rts
2061 6608
2062 6608 60                    rts   
2063 6609
2064 6609                       ENDP 
2065 6609
2066 6609
2067 6609              ********************************************************************************
2068 6609              *
2069 6609              * PushPtrToRect2
2070 6609              *
2071 6609              * Y contains the offset of the pointer to the rectangle to push on the stack.
2072 6609              *
2073 6609              ********************************************************************************
2074 6609              PushPtrToRect2 PROC 
2075 6609
2076 6609 FA                    plx                            ; save return address
2077 660A
2078 660A 98                    tya                            ; y contains the offset in control record of rect to push
2079 660B 18                    clc   
2080 660C 65 05                 adc   CtlPtr                   ; base address of control record
2081 660E A8                    tay   
2082 660F A5 07                 lda   CtlPtr+2                 ; high word of address
2083 6611 69 00 00              adc   #0
2084 6614 48                    pha                            ; push address on the stack
2085 6615 5A                    phy   
2086 6616
2087 6616 DA                    phx                            ; restore the return address
2088 6617
2089 6617 60                    rts   
2090 6618
2091 6618                       ENDP 
2092 6618
2093 6618
2094 6618              ********************************************************************************
2095 6618              PopUpData PROC 
2096 6618
2097 6618              ; --- Masks for dimmed and normal text -----------------------------
2098 6618
2099 6618                       ENTRY dimmed
2100 6618 55 AA 55 AA  dimmed   DC B:$55,$AA,$55,$AA,$55,$AA,$55,$AA
2101 6620                       ENTRY nor_mask
2102 6620 FF FF FF FF  nor_mask DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
2103 6628
2104 6628              ; --- Default menu bar color table ---------------------------
2105 6628              ;
2106 6628                       ENTRY DefColorTable 
2107 6628 F0 00        DefColorTable DC W:$00F0                Normal color, black text on white.
2108 662A 0F 00                 DC W:$000F                     Hilited color, white text on black.
2109 662C 00 00                 DC W:$0000                     Outline color, black.
2110 662E
2111 662E                       ENDP 
2112 662E
2113 662E
2114 662E              ********************************************************************************
2115 662E              *
2116 662E              *                   CheckForIcon
2117 662E              *
2118 662E              * This routine checks to see if the currently selected item has an icon
2119 662E              * associated with it and if it does do we need to draw it.
2120 662E              *
2121 662E              ********************************************************************************
2122 662E              CheckForIcon PROC export 
2123 662E
2124 662E A0 3C 00              ldy   #PopUpCtlRecord.ctlMoreFlags
2125 6631 B7 05                 lda   [<ctlPtr],y
2126 6633 29 20 00              and   #FDrawIconInResult
2127 6636
2128 6636 F0 13                 beq   Error
2129 6638
2130 6638 48                    pha                            ; space for result
2131 6639 48                    pha   
2132 663A A0 12 00              ldy   #PopUpCtlRecord.ctlValue ; get id of selected menu item
2133 663D B7 05                 lda   [<ctlPtr],y
2134 663F 48                    pha   
2135 6640 A2 0F 48 22           _GetMItemIcon 
2136 6647 90 05                 bcc   GotIcon
2137 6649              NoIcon    
2138 6649 FA                    plx   
2139 664A FA                    plx   
2140 664B 82 F4 00     Error    brl   DontDrawIcon             ; clean up stack and return error
2141 664E
2142 664E A3 01        GotIcon  lda   1,s
2143 6650 03 03                 ora   3,s                      ; see if a valid icon ref was passed back
2144 6652 F0 F5                 beq   NoIcon
2145 6654
2146 6654 48                    pha                            ; space for result
2147 6655 A0 12 00              ldy   #PopUpCtlRecord.ctlValue ; get id of selected menu item
2148 6658 B7 05                 lda   [<ctlPtr],y
2149 665A 48                    pha   
2150 665B A2 0F 4C 22           _GetMItemFlag2 
2151 6662 68                    pla   
2152 6663 29 03 00              and   #$0003                   ; low 2 bits of ItemFlag2 tell us how icon is ref.
2153 6666 AA                    tax                            ; move how icon will be referenced in x-reg
2154 6667
2155 6667 48                    pha                            ; space to store iconRef that might need to get released
2156 6668 48                    pha   
2157 6669
2158 6669 A0 10 00              ldy   #PopUpCtlRecord.ctlFlag  ; get title justification information
2159 666C B7 05                 lda   [<ctlPtr],y
2160 666E 29 01 00              and   #$0001
2161 6671 48                    pha   
2162 6672              ;
2163 6672              ; ----- Setup new stack frame ----------------------------------------------------------------
2164 6672              ;
2165 6672                       DefineStack 
2166 6672              DPage    equ   1
2167 6672              Justification equ   DPage+2
2168 6672              IconID   equ   Justification+2
2169 6672              TheIconRef equ   IconID+4
2170 6672              theRTS   equ   TheIconRef+4
2171 6672              yCoord   equ   theRTS+2                 ; position in local coords. that text is to drawn
2172 6672              xCoord   equ   yCoord+2
2173 6672
2174 6672 0B                    phd   
2175 6673 3B                    tsc   
2176 6674 5B                    tcd   
2177 6675
2178 6675 8A                    txa                            ; y-reg defines how icon will referenced
2179 6676
2180 6676 0A                    asl   a                        ; turn into index to table
2181 6677 AA                    tax   
2182 6678
2183 6678 7C 7B 69              jmp   (Table,x)
2184 667B
2185 667B BC 69        Table    DC W:doPointer
2186 667D B0 69                 DC W:doHandle
2187 667F 83 69                 DC W:doResource
2188 6681 4B 69                 DC W:Error                     ; invalid value in moreflags
2189 6683
2190 6683 A5 03        doResource lda   <Justification         ; set bit to indicate icon was a resource
2191 6685 09 00 80              ora   #$8000
2192 6688 85 03                 sta   <Justification
2193 668A
2194 668A A5 09                 lda   <TheIconRef              ; store id of icon resource so we can use it later
2195 668C 85 05                 sta   <IconID                  ; to dispose of this resource
2196 668E A5 0B                 lda   <TheIconRef+2
2197 6690 85 07                 sta   <IconID+2
2198 6692
2199 6692 48                    pha                            ; space for result
2200 6693 48                    pha   
2201 6694 F4 01 80              PushWord #rIcon 
2202 6697 A5 0B 48 A5           PushLong <TheIconRef 
2203 669D A2 1E 0E 22           _LoadResource 
2204 66A4 90 04                 bcc   LoadedOk
2205 66A6 2B                    pld                            ; restore original direct page register
2206 66A7 82 9F FF              brl   NoIcon
2207 66AA
2208 66AA 68           LoadedOk pla                            ; put hdl to icon in a dpage variable
2209 66AB 85 09                 sta   <TheIconRef
2210 66AD 68                    pla   
2211 66AE 85 0B                 sta   <TheIconRef+2
2212 66B0
2213 66B0 A0 02 00     doHandle ldy   #2                       ; deref handle to icon
2214 66B3 B7 09                 lda   [<TheIconRef],y
2215 66B5 AA                    tax   
2216 66B6 A7 09                 lda   [<TheIconRef]
2217 66B8 85 09                 sta   <TheIconRef
2218 66BA 86 0B                 stx   <TheIconRef+2
2219 66BC              doPointer  
2220 66BC              ;
2221 66BC              ; ----- Get ready to make _DrawIcon call ------------------------------------------------------------
2222 66BC              ;
2223 66BC A5 0B 48 A5           PushLong <TheIconRef           ; ptr to icon
2224 66C2 F4 00 00              pea   0                        ; display mode
2225 66C5
2226 66C5 A5 11 48              PushWord <xCoord               ; x coordinate
2227 66C8
2228 66C8 A5 01                 lda   <DPage
2229 66CA AA                    tax   
2230 66CB A0 06 00              ldy   #oQDIconWidth
2231 66CE B7 09                 lda   [<TheIconRef],y
2232 66D0 A8                    tay   
2233 66D1 BF 1D 00 00           lda   >Word7,x
2234 66D5 F0 03                 beq   @In320
2235 66D7 98                    tya   
2236 66D8 0A                    asl   a
2237 66D9 A8                    tay   
2238 66DA A5 03        @In320   lda   <Justification
2239 66DC 29 01 00              and   #$0001
2240 66DF D0 0B                 bne   RightJust
2241 66E1
2242 66E1 98                    tya   
2243 66E2 18                    clc   
2244 66E3 65 11                 adc   <xCoord
2245 66E5 69 02 00              adc   #2
2246 66E8 85 11                 sta   <xCoord
2247 66EA 80 0D                 bra   TitleCoordFudged
2248 66EC              RightJust  
2249 66EC 98                    tya   
2250 66ED 83 01                 sta   1,s
2251 66EF A5 11                 lda   <xCoord
2252 66F1 38                    sec   
2253 66F2 E3 01                 sbc   1,s
2254 66F4 E9 02 00              sbc   #2
2255 66F7 83 01                 sta   1,s
2256 66F9
2257 66F9 A5 01        TitleCoordFudged lda   <DPage
2258 66FB AA                    tax   
2259 66FC BF 0D 00 00           lda   >Rect+y2,x
2260 6700 38                    sec   
2261 6701 FF 09 00 00           sbc   >Rect+y1,x
2262 6705 A0 04 00              ldy   #oQDIconHeight
2263 6708 38                    sec   
2264 6709 F7 09                 sbc   [<TheIconRef],y
2265 670B 18                    clc   
2266 670C 6A                    ror   a
2267 670D 48                    pha   
2268 670E BF 09 00 00           lda   >Rect+y1,x
2269 6712 18                    clc   
2270 6713 63 01                 adc   1,s
2271 6715 83 01                 sta   1,s
2272 6717              *** added 21-Jan-91 DAL for 640 dithering
2273 6717 A3 03                 lda   3,s
2274 6719              ;	and	#$fffe
2275 6719 4A                    lsr   a
2276 671A 0A                    asl   a
2277 671B 83 03                 sta   3,s
2278 671D              *** end of 21-Jan-91 DAL
2279 671D A2 12 0B 22           _DrawIcon                      ; draw the icon in the popup box
2280 6724
2281 6724 A5 03                 lda   <Justification           ; check flag to see if icon was resource
2282 6726 10 13                 bpl   NotResource              ; if it was then we need to release the resource
2283 6728
2284 6728              ;;;	PushWord #$FFFF	; neg. purge level which means handle gets disposed
2285 6728 F4 03 00              pea   3                        ;purge level 3 (7-Dec-91 DAL)
2286 672B F4 01 80              PushWord #rIcon 
2287 672E A5 07 48 A5           PushLong <IconID 
2288 6734 A2 1E 17 22           _ReleaseResource 
2289 673B
2290 673B 2B           NotResource pld                         ; restore direct page
2291 673C 3B                    tsc                            ; clean up stack
2292 673D 18                    clc   
2293 673E 69 0A 00              adc   #10
2294 6741 1B                    tcs   
2295 6742
2296 6742 60           DontDrawIcon rts   
2297 6743
2298 6743                       ENDP 
2299 6743
2300 6743                       END   
